% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_trigger}
\alias{glue_update_trigger}
\title{Updates a trigger definition}
\usage{
glue_update_trigger(Name, TriggerUpdate)
}
\arguments{
\item{Name}{[required] The name of the trigger to update.}

\item{TriggerUpdate}{[required] The new values with which to update the trigger.}
}
\description{
Updates a trigger definition.
}
\section{Request syntax}{
\preformatted{svc$update_trigger(
  Name = "string",
  TriggerUpdate = list(
    Name = "string",
    Description = "string",
    Schedule = "string",
    Actions = list(
      list(
        JobName = "string",
        Arguments = list(
          "string"
        ),
        Timeout = 123,
        NotificationProperty = list(
          NotifyDelayAfter = 123
        ),
        SecurityConfiguration = "string"
      )
    ),
    Predicate = list(
      Logical = "AND"|"ANY",
      Conditions = list(
        list(
          LogicalOperator = "EQUALS",
          JobName = "string",
          State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT"
        )
      )
    )
  )
)
}
}

\keyword{internal}
