# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include quicksight_service.R
NULL

#' Creates an Amazon QuickSight group
#'
#' Creates an Amazon QuickSight group.
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> `.
#' 
#' The response is a group object.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight create-group --aws-account-id=111122223333 --namespace=default --group-name="Sales-Management" --description="Sales Management - Forecasting" `
#'
#' @usage
#' quicksight_create_group(GroupName, Description, AwsAccountId, Namespace)
#'
#' @param GroupName &#91;required&#93; A name for the group that you want to create.
#' @param Description A description for the group that you want to create.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$create_group(
#'   GroupName = "string",
#'   Description = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_create_group
quicksight_create_group <- function(GroupName, Description = NULL, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
    paginator = list()
  )
  input <- .quicksight$create_group_input(GroupName = GroupName, Description = Description, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$create_group_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_group <- quicksight_create_group

#' Adds an Amazon QuickSight user to an Amazon QuickSight group
#'
#' Adds an Amazon QuickSight user to an Amazon QuickSight group.
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> `.
#' 
#' The condition resource is the user name.
#' 
#' The condition key is `quicksight:UserName`.
#' 
#' The response is the group member object.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight create-group-membership --aws-account-id=111122223333 --namespace=default --group-name=Sales --member-name=Pat `
#'
#' @usage
#' quicksight_create_group_membership(MemberName, GroupName, AwsAccountId,
#'   Namespace)
#'
#' @param MemberName &#91;required&#93; The name of the user that you want to add to the group membership.
#' @param GroupName &#91;required&#93; The name of the group that you want to add the user to.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$create_group_membership(
#'   MemberName = "string",
#'   GroupName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_create_group_membership
quicksight_create_group_membership <- function(MemberName, GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "CreateGroupMembership",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
    paginator = list()
  )
  input <- .quicksight$create_group_membership_input(MemberName = MemberName, GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$create_group_membership_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$create_group_membership <- quicksight_create_group_membership

#' Removes a user group from Amazon QuickSight
#'
#' Removes a user group from Amazon QuickSight.
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> `.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight delete-group -\\-aws-account-id=111122223333 -\\-namespace=default -\\-group-name=Sales-Management `
#'
#' @usage
#' quicksight_delete_group(GroupName, AwsAccountId, Namespace)
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to delete.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_group(
#'   GroupName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_group
quicksight_delete_group <- function(GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
    paginator = list()
  )
  input <- .quicksight$delete_group_input(GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_group_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_group <- quicksight_delete_group

#' Removes a user from a group so that the user is no longer a member of
#' the group
#'
#' Removes a user from a group so that the user is no longer a member of
#' the group.
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> `.
#' 
#' The condition resource is the user name.
#' 
#' The condition key is `quicksight:UserName`.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight delete-group-membership --aws-account-id=111122223333 --namespace=default --group-name=Sales-Management --member-name=Charlie `
#'
#' @usage
#' quicksight_delete_group_membership(MemberName, GroupName, AwsAccountId,
#'   Namespace)
#'
#' @param MemberName &#91;required&#93; The name of the user that you want to delete from the group membership.
#' @param GroupName &#91;required&#93; The name of the group that you want to delete the user from.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_group_membership(
#'   MemberName = "string",
#'   GroupName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_group_membership
quicksight_delete_group_membership <- function(MemberName, GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteGroupMembership",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
    paginator = list()
  )
  input <- .quicksight$delete_group_membership_input(MemberName = MemberName, GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_group_membership_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_group_membership <- quicksight_delete_group_membership

#' Deletes the Amazon QuickSight user that is associated with the identity
#' of the AWS Identity and Access Management (IAM) user or role that's
#' making the call
#'
#' Deletes the Amazon QuickSight user that is associated with the identity
#' of the AWS Identity and Access Management (IAM) user or role that\'s
#' making the call. The IAM user isn\'t deleted as a result of this call.
#' 
#' The permission resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt; </i> `.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight delete-user --aws-account-id=111122223333 --namespace=default --user-name=Pat `
#'
#' @usage
#' quicksight_delete_user(UserName, AwsAccountId, Namespace)
#'
#' @param UserName &#91;required&#93; The name of the user that you want to delete.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the user is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user(
#'   UserName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_user
quicksight_delete_user <- function(UserName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
    paginator = list()
  )
  input <- .quicksight$delete_user_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_user_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_user <- quicksight_delete_user

#' Deletes a user after locating the user by its principal ID
#'
#' Deletes a user after locating the user by its principal ID.
#'
#' @usage
#' quicksight_delete_user_by_principal_id(PrincipalId, AwsAccountId,
#'   Namespace)
#'
#' @param PrincipalId &#91;required&#93; The principal ID of the user.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the user is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_by_principal_id(
#'   PrincipalId = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_delete_user_by_principal_id
quicksight_delete_user_by_principal_id <- function(PrincipalId, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DeleteUserByPrincipalId",
    http_method = "DELETE",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
    paginator = list()
  )
  input <- .quicksight$delete_user_by_principal_id_input(PrincipalId = PrincipalId, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$delete_user_by_principal_id_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$delete_user_by_principal_id <- quicksight_delete_user_by_principal_id

#' Returns an Amazon QuickSight group's description and Amazon Resource
#' Name (ARN)
#'
#' Returns an Amazon QuickSight group\'s description and Amazon Resource
#' Name (ARN).
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> `.
#' 
#' The response is the group object.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight describe-group -\\-aws-account-id=11112222333 -\\-namespace=default -\\-group-name=Sales `
#'
#' @usage
#' quicksight_describe_group(GroupName, AwsAccountId, Namespace)
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to describe.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_group(
#'   GroupName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_group
quicksight_describe_group <- function(GroupName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DescribeGroup",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
    paginator = list()
  )
  input <- .quicksight$describe_group_input(GroupName = GroupName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$describe_group_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_group <- quicksight_describe_group

#' Returns information about a user, given the user name
#'
#' Returns information about a user, given the user name.
#' 
#' The permission resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> `.
#' 
#' The response is a user object that contains the user\'s Amazon Resource
#' Name (ARN), AWS Identity and Access Management (IAM) role, and email
#' address.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight describe-user --aws-account-id=111122223333 --namespace=default --user-name=Pat `
#'
#' @usage
#' quicksight_describe_user(UserName, AwsAccountId, Namespace)
#'
#' @param UserName &#91;required&#93; The name of the user that you want to describe.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the user is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user(
#'   UserName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_describe_user
quicksight_describe_user <- function(UserName, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
    paginator = list()
  )
  input <- .quicksight$describe_user_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$describe_user_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$describe_user <- quicksight_describe_user

#' Generates a server-side embeddable URL and authorization code
#'
#' Generates a server-side embeddable URL and authorization code. Before
#' this can work properly, first you need to configure the dashboards and
#' user permissions. For more information, see [Embedding Amazon QuickSight
#' Dashboards](https://docs.aws.amazon.com/en_us/quicksight/latest/user/embedding.html).
#' 
#' Currently, you can use `GetDashboardEmbedURL` only from the server, not
#' from the user's browser.
#' 
#' **CLI Sample:**
#' 
#' Assume the role with permissions enabled for actions:
#' `quickSight:RegisterUser` and `quicksight:GetDashboardEmbedURL`. You can
#' use assume-role, assume-role-with-web-identity, or
#' assume-role-with-saml.
#' 
#' `aws sts assume-role --role-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role" --role-session-name embeddingsession`
#' 
#' If the user does not exist in QuickSight, register the user:
#' 
#' `aws quicksight register-user --aws-account-id 111122223333 --namespace default --identity-type IAM --iam-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role" --user-role READER --session-name "embeddingsession" --email user123@example.com --region us-east-1`
#' 
#' Get the URL for the embedded dashboard
#' 
#' `aws quicksight get-dashboard-embed-url --aws-account-id 111122223333 --dashboard-id 1a1ac2b2-3fc3-4b44-5e5d-c6db6778df89 --identity-type IAM`
#'
#' @usage
#' quicksight_get_dashboard_embed_url(AwsAccountId, DashboardId,
#'   IdentityType, SessionLifetimeInMinutes, UndoRedoDisabled, ResetDisabled)
#'
#' @param AwsAccountId &#91;required&#93; AWS account ID that contains the dashboard you are embedding.
#' @param DashboardId &#91;required&#93; The ID for the dashboard, also added to IAM policy
#' @param IdentityType &#91;required&#93; The authentication method the user uses to sign in (IAM only).
#' @param SessionLifetimeInMinutes How many minutes the session is valid. The session lifetime must be
#' between 15 and 600 minutes.
#' @param UndoRedoDisabled Remove the undo/redo button on embedded dashboard. The default is FALSE,
#' which enables the undo/redo button.
#' @param ResetDisabled Remove the reset button on embedded dashboard. The default is FALSE,
#' which allows the reset button.
#'
#' @section Request syntax:
#' ```
#' svc$get_dashboard_embed_url(
#'   AwsAccountId = "string",
#'   DashboardId = "string",
#'   IdentityType = "IAM"|"QUICKSIGHT",
#'   SessionLifetimeInMinutes = 123,
#'   UndoRedoDisabled = TRUE|FALSE,
#'   ResetDisabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_get_dashboard_embed_url
quicksight_get_dashboard_embed_url <- function(AwsAccountId, DashboardId, IdentityType, SessionLifetimeInMinutes = NULL, UndoRedoDisabled = NULL, ResetDisabled = NULL) {
  op <- new_operation(
    name = "GetDashboardEmbedUrl",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
    paginator = list()
  )
  input <- .quicksight$get_dashboard_embed_url_input(AwsAccountId = AwsAccountId, DashboardId = DashboardId, IdentityType = IdentityType, SessionLifetimeInMinutes = SessionLifetimeInMinutes, UndoRedoDisabled = UndoRedoDisabled, ResetDisabled = ResetDisabled)
  output <- .quicksight$get_dashboard_embed_url_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$get_dashboard_embed_url <- quicksight_get_dashboard_embed_url

#' Lists member users in a group
#'
#' Lists member users in a group.
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> `.
#' 
#' The response is a list of group member objects.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight list-group-memberships -\\-aws-account-id=111122223333 -\\-namespace=default `
#'
#' @usage
#' quicksight_list_group_memberships(GroupName, NextToken, MaxResults,
#'   AwsAccountId, Namespace)
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to see a membership list of.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return from this request.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$list_group_memberships(
#'   GroupName = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_list_group_memberships
quicksight_list_group_memberships <- function(GroupName, NextToken = NULL, MaxResults = NULL, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "ListGroupMemberships",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
    paginator = list()
  )
  input <- .quicksight$list_group_memberships_input(GroupName = GroupName, NextToken = NextToken, MaxResults = MaxResults, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$list_group_memberships_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_group_memberships <- quicksight_list_group_memberships

#' Lists all user groups in Amazon QuickSight
#'
#' Lists all user groups in Amazon QuickSight.
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*`.
#' 
#' The response is a list of group objects.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight list-groups -\\-aws-account-id=111122223333 -\\-namespace=default `
#'
#' @usage
#' quicksight_list_groups(AwsAccountId, NextToken, MaxResults, Namespace)
#'
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$list_groups(
#'   AwsAccountId = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_list_groups
quicksight_list_groups <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL, Namespace) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
    paginator = list()
  )
  input <- .quicksight$list_groups_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace)
  output <- .quicksight$list_groups_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_groups <- quicksight_list_groups

#' Lists the Amazon QuickSight groups that an Amazon QuickSight user is a
#' member of
#'
#' Lists the Amazon QuickSight groups that an Amazon QuickSight user is a
#' member of.
#' 
#' The permission resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> `.
#' 
#' The response is a one or more group objects.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight list-user-groups -\\-user-name=Pat -\\-aws-account-id=111122223333 -\\-namespace=default -\\-region=us-east-1 `
#'
#' @usage
#' quicksight_list_user_groups(UserName, AwsAccountId, Namespace,
#'   NextToken, MaxResults)
#'
#' @param UserName &#91;required&#93; The Amazon QuickSight user name that you want to list group memberships
#' for.
#' @param AwsAccountId &#91;required&#93; The AWS Account ID that the user is in. Currently, you use the ID for
#' the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return from this request.
#'
#' @section Request syntax:
#' ```
#' svc$list_user_groups(
#'   UserName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_list_user_groups
quicksight_list_user_groups <- function(UserName, AwsAccountId, Namespace, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUserGroups",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
    paginator = list()
  )
  input <- .quicksight$list_user_groups_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace, NextToken = NextToken, MaxResults = MaxResults)
  output <- .quicksight$list_user_groups_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_user_groups <- quicksight_list_user_groups

#' Returns a list of all of the Amazon QuickSight users belonging to this
#' account
#'
#' Returns a list of all of the Amazon QuickSight users belonging to this
#' account.
#' 
#' The permission resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>*</i> `.
#' 
#' The response is a list of user objects, containing each user\'s Amazon
#' Resource Name (ARN), AWS Identity and Access Management (IAM) role, and
#' email address.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight list-users --aws-account-id=111122223333 --namespace=default `
#'
#' @usage
#' quicksight_list_users(AwsAccountId, NextToken, MaxResults, Namespace)
#'
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the user is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param NextToken A pagination token that can be used in a subsequent request.
#' @param MaxResults The maximum number of results to return from this request.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$list_users(
#'   AwsAccountId = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_list_users
quicksight_list_users <- function(AwsAccountId, NextToken = NULL, MaxResults = NULL, Namespace) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "GET",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
    paginator = list()
  )
  input <- .quicksight$list_users_input(AwsAccountId = AwsAccountId, NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace)
  output <- .quicksight$list_users_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$list_users <- quicksight_list_users

#' Creates an Amazon QuickSight user, whose identity is associated with the
#' AWS Identity and Access Management (IAM) identity or role specified in
#' the request
#'
#' Creates an Amazon QuickSight user, whose identity is associated with the
#' AWS Identity and Access Management (IAM) identity or role specified in
#' the request.
#' 
#' The permission resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> `.
#' 
#' The condition resource is the Amazon Resource Name (ARN) for the IAM
#' user or role, and the session name.
#' 
#' The condition keys are `quicksight:IamArn` and `quicksight:SessionName`.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight register-user -\\-aws-account-id=111122223333 -\\-namespace=default -\\-email=pat@example.com -\\-identity-type=IAM -\\-user-role=AUTHOR -\\-iam-arn=arn:aws:iam::111122223333:user/Pat `
#'
#' @usage
#' quicksight_register_user(IdentityType, Email, UserRole, IamArn,
#'   SessionName, AwsAccountId, Namespace, UserName)
#'
#' @param IdentityType &#91;required&#93; Amazon QuickSight supports several ways of managing the identity of
#' users. This parameter accepts two values:
#' 
#' -   `IAM`: A user whose identity maps to an existing IAM user or role.
#' 
#' -   `QUICKSIGHT`: A user whose identity is owned and managed internally
#'     by Amazon QuickSight.
#' @param Email &#91;required&#93; The email address of the user that you want to register.
#' @param UserRole &#91;required&#93; The Amazon QuickSight role of the user. The user role can be one of the
#' following:
#' 
#' -   `READER`: A user who has read-only access to dashboards.
#' 
#' -   `AUTHOR`: A user who can create data sources, data sets, analyses,
#'     and dashboards.
#' 
#' -   `ADMIN`: A user who is an author, who can also manage Amazon
#'     QuickSight settings.
#' @param IamArn The ARN of the IAM user or role that you are registering with Amazon
#' QuickSight.
#' @param SessionName The name of the session with the assumed IAM role. By using this
#' parameter, you can register multiple users with the same IAM role,
#' provided that each has a different session name. For more information on
#' assuming IAM roles, see
#' [`assume-role`](https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html)
#' in the *AWS CLI Reference.*
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the user is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#' @param UserName The Amazon QuickSight user name that you want to create for the user you
#' are registering.
#'
#' @section Request syntax:
#' ```
#' svc$register_user(
#'   IdentityType = "IAM"|"QUICKSIGHT",
#'   Email = "string",
#'   UserRole = "ADMIN"|"AUTHOR"|"READER"|"RESTRICTED_AUTHOR"|"RESTRICTED_READER",
#'   IamArn = "string",
#'   SessionName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string",
#'   UserName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_register_user
quicksight_register_user <- function(IdentityType, Email, UserRole, IamArn = NULL, SessionName = NULL, AwsAccountId, Namespace, UserName = NULL) {
  op <- new_operation(
    name = "RegisterUser",
    http_method = "POST",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
    paginator = list()
  )
  input <- .quicksight$register_user_input(IdentityType = IdentityType, Email = Email, UserRole = UserRole, IamArn = IamArn, SessionName = SessionName, AwsAccountId = AwsAccountId, Namespace = Namespace, UserName = UserName)
  output <- .quicksight$register_user_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$register_user <- quicksight_register_user

#' Changes a group description
#'
#' Changes a group description.
#' 
#' The permissions resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> `.
#' 
#' The response is a group object.
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight update-group --aws-account-id=111122223333 --namespace=default --group-name=Sales --description="Sales BI Dashboards" `
#'
#' @usage
#' quicksight_update_group(GroupName, Description, AwsAccountId, Namespace)
#'
#' @param GroupName &#91;required&#93; The name of the group that you want to update.
#' @param Description The description for the group that you want to update.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the group is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#'
#' @section Request syntax:
#' ```
#' svc$update_group(
#'   GroupName = "string",
#'   Description = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_update_group
quicksight_update_group <- function(GroupName, Description = NULL, AwsAccountId, Namespace) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
    paginator = list()
  )
  input <- .quicksight$update_group_input(GroupName = GroupName, Description = Description, AwsAccountId = AwsAccountId, Namespace = Namespace)
  output <- .quicksight$update_group_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_group <- quicksight_update_group

#' Updates an Amazon QuickSight user
#'
#' Updates an Amazon QuickSight user.
#' 
#' The permission resource is
#' `arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> `.
#' 
#' The response is a user object that contains the user\'s Amazon
#' QuickSight user name, email address, active or inactive status in Amazon
#' QuickSight, Amazon QuickSight role, and Amazon Resource Name (ARN).
#' 
#' **CLI Sample:**
#' 
#' `aws quicksight update-user --user-name=Pat --role=ADMIN --email=new_address@amazon.com --aws-account-id=111122223333 --namespace=default --region=us-east-1 `
#'
#' @usage
#' quicksight_update_user(UserName, AwsAccountId, Namespace, Email, Role)
#'
#' @param UserName &#91;required&#93; The Amazon QuickSight user name that you want to update.
#' @param AwsAccountId &#91;required&#93; The ID for the AWS account that the user is in. Currently, you use the
#' ID for the AWS account that contains your Amazon QuickSight account.
#' @param Namespace &#91;required&#93; The namespace. Currently, you should set this to `default`.
#' @param Email &#91;required&#93; The email address of the user that you want to update.
#' @param Role &#91;required&#93; The Amazon QuickSight role of the user. The user role can be one of the
#' following:
#' 
#' -   `READER`: A user who has read-only access to dashboards.
#' 
#' -   `AUTHOR`: A user who can create data sources, data sets, analyses,
#'     and dashboards.
#' 
#' -   `ADMIN`: A user who is an author, who can also manage Amazon
#'     QuickSight settings.
#'
#' @section Request syntax:
#' ```
#' svc$update_user(
#'   UserName = "string",
#'   AwsAccountId = "string",
#'   Namespace = "string",
#'   Email = "string",
#'   Role = "ADMIN"|"AUTHOR"|"READER"|"RESTRICTED_AUTHOR"|"RESTRICTED_READER"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname quicksight_update_user
quicksight_update_user <- function(UserName, AwsAccountId, Namespace, Email, Role) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "PUT",
    http_path = "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
    paginator = list()
  )
  input <- .quicksight$update_user_input(UserName = UserName, AwsAccountId = AwsAccountId, Namespace = Namespace, Email = Email, Role = Role)
  output <- .quicksight$update_user_output()
  svc <- .quicksight$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.quicksight$operations$update_user <- quicksight_update_user
