% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternpie.R
\name{patternpie}
\alias{patternpie}
\title{Plot a pie chart using patterns and colors to fill the slices.}
\usage{
patternpie(group, pct, label, label.size = 4, label.color = "black",
  label.distance = 1.2, pattern.type, pattern.color = rep("black",
  length(group)), pattern.line.size = 1, background.color = rep("white",
  length(group)), frame.color = "black", frame.size = 1, pixel = 0.3,
  density = rep(10, length(group)))
}
\arguments{
\item{group}{a vector of strings, containing the names of each slice.}

\item{pct}{a vector of non-negative numbers, containing percentages of each group.
The numbers must sum up to 100.}

\item{label}{a vector of strings, giving the names for the slices shown in the pie chart.}

\item{label.size}{the font size of labels shown in the pie chart.}

\item{label.color}{the color of labels shown in the pie chart.}

\item{label.distance}{the distance of labels from the border of the pie chart.}

\item{pattern.type}{a vector of patterns to be filled in the slices. 
There are 15 pattern types: 'blank', 'bricks', 'circles1','circles2', 'vdashes', 'hdashes',
'crosshatch','dots', 'grid','hlines','nelines', 'nwlines', 'shells', 'vlines', 'waves'.}

\item{pattern.color}{a vector of colors for the lines/dots of patterns.}

\item{pattern.line.size}{a numeric value, the line size for the lines/dots of patterns.}

\item{background.color}{a vector of colors to be filled in the slices.}

\item{frame.color}{the color for the borders of slices.}

\item{frame.size}{a numeric value, the line size for the borders of slices.}

\item{pixel}{a numeric value, the pixel resolution of pie chart.}

\item{density}{a numeric vector, the density for the lines/dots of patterns.}
}
\value{
A ggplot object.
}
\description{
The \code{patternpie} function is a tool for creating versatile pie charts 
by filling the slices with colors and patterns.
}
\details{
\code{patternpie} function offers flexible ways in doing pie charts.
}
\examples{
#Example 1
library(patternplot)
data <- read.csv(system.file("extdata", "vegetables.csv", package="patternplot"))
pattern.type<-c('hdashes', 'vdashes', 'bricks')
patternpie(group=data$group,pct=data$pct,label=data$label, pattern.type=pattern.type, 
           pixel=0.3, pattern.line.size=0.2, frame.size=1.5)

#Example 2
pattern.color<-c('red3','green3', 'white' )
background.color<-c('dodgerblue', 'lightpink', 'orange')
patternpie(group=data$group,pct=data$pct,label=data$label, pattern.type=pattern.type,
           pattern.color=pattern.color,background.color=background.color, 
           frame.color='grey40', pixel=0.3, pattern.line.size=0.3, frame.size=1.5)
}
\seealso{
Function \code{imagepie}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
