% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternbar.R
\name{patternbar}
\alias{patternbar}
\title{Plot a bar chart using patterns and colors to fill the bars.}
\usage{
patternbar(data, x, y, group = NULL, xlab = "", ylab = "",
  label.size = 3.5, vjust = -1, pattern.type, pattern.line.size = 1,
  frame.size = 1, pattern.color = rep("black", ifelse(is.null(group),
  length(x), length(unique(group)))), background.color = rep("white",
  ifelse(is.null(group), length(x), length(unique(group)))), pixel = 1,
  density = rep(7, ifelse(is.null(group), length(x), length(unique(group)))),
  frame.color = rep("black", ifelse(is.null(group), length(x),
  length(unique(group)))), legend.type = "h", legend.h = 6,
  legend.y.pos = 0.5, legend.pixel = 0.1)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{label.size}{the font size of labels shown above the bars.}

\item{vjust}{the distance of labels from the top border of each bar.}

\item{pattern.type}{a vector of patterns to be filled in the bars
There are 15 pattern types: 'blank', 'bricks', 'circles1','circles2', 'vdashes', 'hdashes',
'crosshatch','dots', 'grid','hlines','nelines', 'nwlines', 'shells', 'vlines', 'waves'.}

\item{pattern.line.size}{a numeric value, the line size for the lines/dots of patterns.}

\item{frame.size}{a numeric value, the line size for the borders of bars.}

\item{pattern.color}{a vector of colors for the lines/dots of patterns.}

\item{background.color}{a vector of colors to be filled in the bars.}

\item{pixel}{a numeric value, the pixel resolution of bar chart.}

\item{density}{a numeric vector, the density for the lines/dots of patterns.}

\item{frame.color}{the color for the borders of bars.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal; if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to change the height of legend boxes.}

\item{legend.y.pos}{a numeric value to change the position of legends on y axis.}

\item{legend.pixel}{a numeric value to change the pixel of legends.}
}
\value{
A ggplot object.
}
\description{
The \code{patternbar} function is a tool for creating versatile bar charts
by filling the bars with colors and patterns.
}
\details{
\code{patternbar} function offers flexible ways in doing bar charts.
}
\examples{
#Example 1
data <- read.csv(system.file("extdata", "monthlyexp.csv", package="patternplot"))
data<-data[which(data$Location=='City 1'),]
x<-factor(data$Type, c('Housing', 'Food',  'Childcare'))
y<-data$Amount
pattern.type<-c('hdashes', 'blank', 'crosshatch')
pattern.color=c('black','black', 'black')
background.color=c('white','white', 'white')
density<-c(20, 20, 10)
patternbar(data,x, y,group=NULL,ylab='Monthly Expenses, Dollars', pattern.type=pattern.type,
           pattern.color=pattern.color, background.color=background.color,
           pattern.line.size=0.5,frame.color=c('black', 'black', 'black'), density=density)

#Example 2
pattern.color=c('black','white', 'grey20')
background.color=c('lightgreen','lightgreen', 'lightgreen')
patternbar(data,x, y,group=NULL,ylab='Monthly Expenses, Dollars', pattern.type=pattern.type,
           pattern.color=pattern.color, background.color=background.color,
           pattern.line.size=0.5,frame.color=c('black', 'black', 'black'), density=density)

}
\seealso{
Function \code{patternbar}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
