% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patRegW.R
\name{patRegW}
\alias{patRegW}
\title{Aligns images using \code{\link[RNiftyReg]{niftyreg}} utilities for automated image registration
and extracts color pattern using watershed segmentation. This function works interactively by
allowing to pick a starting pixel within each pattern element from which the watershed will
extract the pattern. This function works best for patterns with sharp boundaries.}
\usage{
patRegW(sampleList, target, resampleFactor = NULL,
  useBlockPercentage = 75, crop = c(0, 0, 0, 0), removebgR = NULL,
  maskOutline = NULL, cartoonID = NULL, correct = FALSE,
  blur = TRUE, sigma = 3, bucketfill = TRUE, cleanP = NULL,
  splitC = NULL, plotTransformed = FALSE, plotCorrect = FALSE,
  plotEdges = FALSE, plotPriority = FALSE, plotWS = FALSE,
  plotBF = FALSE, plotFinal = FALSE)
}
\arguments{
\item{sampleList}{List of RasterStack objects.}

\item{target}{Image imported as RasterStack used as target for registration.}

\item{resampleFactor}{Integer for downsampling image used by \code{\link{redRes}}.}

\item{useBlockPercentage}{Block percentage as used in \code{\link[RNiftyReg]{niftyreg}}
(default = 75).}

\item{crop}{Vector c(xmin, xmax, ymin, ymax) that specifies the pixel coordinates to crop the
original image.}

\item{removebgR}{Integer indicating the range RGB treshold to remove from image (e.g. 100 removes
pixels with average RGB > 100; default = NULL) for registration analysis. This works only to
remove a white background.}

\item{maskOutline}{When outline is specified, everything outside of the outline will be masked for
the color extraction (default = NULL).}

\item{cartoonID}{ID of the sample for which the cartoon was drawn and will be used for masking.}

\item{correct}{Correct image illumination using a linear model (default = FALSE).}

\item{blur}{Blur image for priority map extraction (default = TRUE).}

\item{sigma}{Size of sigma for Gaussian blurring (default = 5).}

\item{bucketfill}{Use a bucket fill on the background to fill holes (default = TRUE).}

\item{cleanP}{Integer to remove spurious areas with width smaller than cleanP (default = NULL).}

\item{splitC}{Integer to split selected patterns into connected components and remove ones with
areas smaller than splitC (default = NULL).}

\item{plotTransformed}{Plot transformed image (default = FALSE).}

\item{plotCorrect}{Plot corrected image, corrected for illumination using a linear model
(default = FALSE).}

\item{plotEdges}{Plot image gradient (default = FALSE).}

\item{plotPriority}{Plot priority map (default = FALSE).}

\item{plotWS}{Plot watershed result (default = FALSE).}

\item{plotBF}{Plot bucketfill (default = FALSE).}

\item{plotFinal}{Plot extracted patterns (default = FALSE).}
}
\value{
List of raster objects.
}
\description{
Aligns images using \code{\link[RNiftyReg]{niftyreg}} utilities for automated image registration
and extracts color pattern using watershed segmentation. This function works interactively by
allowing to pick a starting pixel within each pattern element from which the watershed will
extract the pattern. This function works best for patterns with sharp boundaries.
}
\examples{
\dontrun{
IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')
prepath <- system.file("extdata",  package = 'patternize')
extension <- '.jpg'

imageList <- makeList(IDlist, 'image', prepath, extension)

target <- imageList[[1]]

outline_BC0077 <- read.table(paste(system.file("extdata",  package = 'patternize'),
'/BC0077_outline.txt', sep=''), header = FALSE)

rasterList_regW <- patRegW(imageList, target, plotTransformed = FALSE, cartoonID = 'BC0077',
                          correct = TRUE, plotCorrect = FALSE, blur = FALSE, sigma = 2,
                          bucketfill = FALSE, cleanP = 0, splitC = 10, plotPriority = TRUE,
                          plotWS = FALSE, plotBF = FALSE, plotFinal = TRUE, removebgR = 100,
                          maskOutline = outline_BC0077)
}

}
