% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeat.R
\name{plotHeat}
\alias{plotHeat}
\title{Plots the color pattern heatmaps from \code{sumRaster} output.}
\usage{
plotHeat(summedRaster, IDlist, colpalette = NULL, plotCartoon = FALSE,
  refShape = NULL, outline = NULL, lines = NULL, landList = NULL,
  adjustCoords = FALSE, cartoonID = NULL, normalized = FALSE,
  crop = c(0, 0, 0, 0), flipRaster = NULL, flipOutline = NULL,
  imageList = NULL, cartoonOrder = "above", lineOrder = "above",
  cartoonCol = "gray", cartoonFill = NULL, plotLandmarks = FALSE,
  landCol = "black", zlim = c(0, 1), legendTitle = "Proportion",
  xlab = "", ylab = "", main = "", plotPCA = FALSE)
}
\arguments{
\item{summedRaster}{Summed raster or summedRasterList.}

\item{IDlist}{List of sample IDs.}

\item{colpalette}{Vector of colors for color palette
(default = c("white","lightblue","blue","green", "yellow","red"))}

\item{plotCartoon}{Whether to plot a cartoon. This cartoon should be drawn on one of the samples
used in the analysis.}

\item{refShape}{This can be 'target' in case the reference shape is a single sample (for
registration analysis) or 'mean' if the images were transformed to a mean shape (only for
meanshape when using landmark transformation)}

\item{outline}{xy coordinates that define outline.}

\item{lines}{list of files with xy coordinates of line objects to be added to cartoon.}

\item{landList}{Landmark landmarkList.}

\item{adjustCoords}{Adjust landmark coordinates.}

\item{cartoonID}{ID of the sample for which the cartoon was drawn.}

\item{normalized}{Set this to true in case the summed rasters are already devided by the
sample number.}

\item{crop}{Vector c(xmin, xmax, ymin, ymax) that specifies the pixel coordinates to crop
the original image used in landmark or registration analysis.}

\item{flipRaster}{Whether to flip raster along xy axis (in case there is an inconsistency
between raster and outline coordinates).}

\item{flipOutline}{Whether to flip plot along x, y or xy axis.}

\item{imageList}{List of image should be given if one wants to flip the outline or adjust
landmark coordinates.}

\item{cartoonOrder}{Whether to plot the cartoon outline 'above' or 'under' the pattern raster
(default = 'above'). Set to 'under' for filled outlines.}

\item{lineOrder}{Whether to plot the cartoon lines 'above' or 'under' the pattern raster
(default = 'above').}

\item{cartoonCol}{Outline and line color for cartoon (deafault = 'gray').}

\item{cartoonFill}{Fill color for outline of cartoon (default = NULL).}

\item{plotLandmarks}{Whether to plot the landmarks from the target image or mean shape
landmarks (default = FALSE).}

\item{landCol}{Color for ploting landmarks (default = 'black').}

\item{zlim}{z-axis limit (default = c(0,1))}

\item{legendTitle}{Title of the raster legend (default = 'Proportion')}

\item{xlab}{Optional x-axis label.}

\item{ylab}{Optional y-axis label.}

\item{main}{Optional main title.}

\item{plotPCA}{Set as TRUE when visualizing shape changes along PCA axis in \
code{\link[patternize]{patPCA}}.}
}
\description{
Plots the color pattern heatmaps from \code{sumRaster} output.
}
\examples{
data(rasterList_lanRGB)
IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')
outline_BC0077 <- read.table(paste(system.file("extdata",  package = 'patternize'),
'/BC0077_outline.txt', sep=''), header = FALSE)
lines_BC0077 <- list.files(path=paste(system.file("extdata",  package = 'patternize')),
pattern='vein', full.names = TRUE)

summedRaster_regRGB <- sumRaster(rasterList_regRGB, IDlist, type = 'RGB')
data(imageList)

plotHeat(summedRaster_regRGB, IDlist, plotCartoon = TRUE, refShape = 'target',
outline = outline_BC0077, lines = lines_BC0077, crop = c(100,400,40,250),
flipRaster = 'xy', imageList = imageList, cartoonOrder = 'under',
cartoonFill = 'black', main = 'registration_example')

\dontrun{
data(rasterList_lanK)
IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')
summedRasterList <- sumRaster(rasterList_lanK, IDlist, type = 'k')
plotHeat(summedRasterList, IDlist)

summedRasterList_regK <- sumRaster(rasterList_regK, IDlist, type = 'k')
plotHeat(summedRasterList_regK, IDlist, plotCartoon = TRUE, refShape = 'target',
outline = outline_BC0077, lines = lines_BC0077, crop = c(100,400,40,250),
flipRaster = 'y', imageList = imageList, cartoonOrder = 'under',
cartoonFill = 'black', main = 'kmeans_example')

plotHeat(summedRasterList_regK[[1]], IDlist, plotCartoon = TRUE, refShape = 'target',
outline = outline_BC0077, lines = lines_BC0077, crop = c(100,400,40,250),
flipRaster = 'y', imageList = imageList, cartoonOrder = 'under',
cartoonFill = 'black', main = 'kmeans_example')


prepath <- system.file("extdata", package = 'patternize')
extension <- '_landmarks_LFW.txt'
landmarkList <- makeList(IDlist, 'landmark', prepath, extension)

summedRaster_lanRGB <- sumRaster(rasterList_lanRGB, IDlist, type = 'RGB')

plotHeat(summedRaster_lanRGB, IDlist, plotCartoon = TRUE, refShape = 'mean',
outline = outline_BC0077, lines = lines_BC0077, landList = landmarkList,
adjustCoords = TRUE, imageList = imageList, cartoonID = 'BC0077',
cartoonOrder = 'under', cartoonFill= 'black', main = 'Landmark_example')

summedRaster_lanK <- sumRaster(rasterList_lanK, IDlist, type = 'k')

plotHeat(summedRaster_lanK, IDlist, plotCartoon = TRUE, refShape = 'mean',
outline = outline_BC0077, lines = lines_BC0077, landList = landmarkList,
adjustCoords = TRUE, imageList = imageList, cartoonID = 'BC0077',
cartoonOrder = 'under', cartoonFill= 'black', main = 'Landmark_example')

plotHeat(summedRaster_lanK[[2]], IDlist, plotCartoon = TRUE, refShape = 'mean',
outline = outline_BC0077, lines = lines_BC0077, landList = landmarkList,
adjustCoords = TRUE, imageList = imageList, cartoonID = 'BC0077',
cartoonOrder = 'under', cartoonFill= 'black', main = 'Landmark_example')
}

}
