% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subjectProfileLinePlot.R
\name{subjectProfileLinePlot}
\alias{subjectProfileLinePlot}
\title{Visualize subject profiles of the evolution of 
continuous parameters versus time (spaghetti plot).}
\usage{
subjectProfileLinePlot(
  data,
  paramValueVar,
  paramLab = getLabelVar(paramValueVar, labelVars = labelVars),
  paramNameVar = NULL,
  paramVarSep = " - ",
  paramValueRangeVar = NULL,
  colorValueRange = "lightgreen",
  yLimFrom = c("all", "value"),
  colorVar = NULL,
  colorLab = getLabelVar(colorVar, labelVars = labelVars),
  colorPalette = NULL,
  shapeVar = colorVar,
  shapeLab = if (isTRUE(colorVar == shapeVar)) {     colorLab } else
    getLabelVar(shapeVar, labelVars = labelVars),
  shapePalette = NULL,
  paramGroupVar = NULL,
  timeVar,
  timeLab = getLabelVar(timeVar, labelVars = labelVars),
  timeTrans = NULL,
  timeExpand = NULL,
  subjectVar = "USUBJID",
  subjectSubset = NULL,
  subjectSample = NULL,
  seed = 123,
  subsetData = NULL,
  subsetVar = NULL,
  subsetValue = NULL,
  xLab = timeLab,
  yLab = "",
  timeLim = NULL,
  title = toString(getLabelVar(paramValueVar, labelVars = labelVars, label = paramLab)),
  label = title,
  labelVars = NULL,
  formatReport = subjectProfileReportFormat(),
  paging = TRUE,
  alpha = 1,
  shapeSize = rel(1)
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{paramValueVar}{String, variable of \code{data} 
with parameter value to represent.\cr
Records with missing values are discarded.}

\item{paramLab}{Named character vector, 
with label for the parameter variable(s) (\code{paramNameVar}).\cr
This is used to set the default title.}

\item{paramNameVar}{Character vector with variable(s) of \code{data} with parameter name.
If multiple, they are concatenated with \code{paramVarSep}.}

\item{paramVarSep}{string with character(s) used to concatenate multiple 
\code{paramNameVar}, ' - ' by default.}

\item{paramValueRangeVar}{Character vector of length 2 containing 
variables of \code{data} with minimum and maximum value 
for \code{paramValueVar}, typically reference range indicators.\cr
Range can differ per parameter and even per time point.
This range is represented as a ribbon in the plot background.
e.g. to represent the reference range of the variable.}

\item{colorValueRange}{String with color for the filling of 
the ribbon represented by \code{paramValueRangeVar}.}

\item{yLimFrom}{String with specification on the limits of the y-axis, either:
\itemize{
\item{'all' (by default): }{for each parameter (\code{paramNameVar}), 
the y-axis range contains the minimum/maximum value of 
the reference range (\code{paramValueRangeVar}) or data}
\item{'value': }{for each parameter (\code{paramNameVar}), 
the y-axis minimum/maximum value is restricted to the data range only.
Please note that the ribbon visualizing the reference range is also restricted
to the data range if wider.}
}}

\item{colorVar}{String, variable of \code{data} with color.
This variable is used
for the colors and the filling of the points.}

\item{colorLab}{String, label for \code{colorVar}.}

\item{colorPalette}{Named vector with color palette.
The variable should be named with the corresponding element
in \code{colorVar}.\cr
Colors can also be defined for the entire session, by setting
\code{options(patientProfilesVis.colors = X)} with X either:
\itemize{
\item{a vector with colors}
\item{a function returning a vector of colors for a specified number
of elements (\code{viridis} by default)}
}}

\item{shapeVar}{String, variable of \code{data} for shape of the points.
By default, same as \code{colorVar}.}

\item{shapeLab}{String, label for \code{shapeVar}.
Set by default to \code{colorLab} if \code{colorVar}
but not \code{shapeVar} is not specified.}

\item{shapePalette}{Named character vector with shape palette
for \code{shapeVar}.
The variable should be named with the corresponding element
in \code{shapeVar}.\cr
Shapes can also be defined for the entire session, by setting
\code{options(patientProfilesVis.shapes = X)} with X either:
\itemize{
\item{a vector with shapes}
\item{a function returning a vector of shapes for a specified number
of elements}
}
Note it is advised to specify the shapes as character,
e.g. 'cross' instead of \code{4}, in case Unicode
symbols should also be used.}

\item{paramGroupVar}{(optional) Character vector with variable(s) 
of \code{data} based on which the data will be grouped and sorted 
(in the y-axis) in the plot.}

\item{timeVar}{String, variable of \code{data} with time,
displayed in the x axis.\cr
Records with missing time are not displayed in the plot.}

\item{timeLab}{String, label for \code{timeVar}.
This is used in the message
indicating missing values for \code{timeVar},
and for the default label of the x-axis.}

\item{timeTrans}{transformation for the time variable, 
(see \code{trans} parameter in \code{\link[ggplot2]{scale_x_continuous}}, and
\code{\link[scales]{trans_new}}).
For example, produced by the \code{\link{getTimeTrans}} function.}

\item{timeExpand}{Vector of range expansion constants for the time axis
(see \code{expand} parameter in \code{\link[ggplot2]{scale_x_continuous}}).}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{subjectSubset}{(optional) Character vector with subjects of interest 
(available in \code{subjectVar}), NULL by default.}

\item{subjectSample}{(optional) Integer of length 1
with number of random subject(s) that should be considered,
e.g. to check the created patient profiles for a subset of the data.
By default, all specified subjects are considered (set to NULL).}

\item{seed}{(optional) Integer of length 1 with seed used to select random subjects 
if \code{subjectSample} is specified (123 by default).}

\item{subsetData}{(optional) Data.frame with extra dataset to filter on.
This dataset is filtered, and only records from \code{data} 
with common subject IDs will be retained.\cr
If not specified, \code{data} is used.}

\item{subsetVar}{(optional) String with variable of subset data to filter on.
\code{subsetValue} should be specified too.\cr
If not specified, all records from the subset data are retained.}

\item{subsetValue}{(optional) Character vector with value(s) of interest to
retain in the filtered data.
These values should be available in \code{subsetVar}.\cr
Missing values in the subject variable are not retained 
in the filtered data.}

\item{xLab}{String, label for the x-axis.}

\item{yLab}{String, label for the y-axis.}

\item{timeLim}{(optional) Vector of length 2 with time limits (x-axis).
If not specified, these are extracted from the minimum \code{timeStartVar} 
and maximum \code{timeEndVar} per subject.\cr
The time limits are stored as attributes of the plots,
used to align the plots in the final report.}

\item{title}{String with title, label of the parameter value variable by default.}

\item{label}{String, label for the visualization.
This label is stored as attributes of the output
from the \code{subjectProfile[]Plot} function.\cr
This label is displayed in the final profile
report, in case no data is available for
for a specific patient, as: 'No [label] available.'}

\item{labelVars}{Named character vector with variable labels 
(names are the variable code)}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}

\item{paging}{Logical, if TRUE (by default), automatic 
paging is enabled, so patient profiles module too big to fit
in one page will span multiple pages.
Please note that the size of the graphic window 
(or report page) may need
to be re-sized in order that the plot fits.
\cr
If FALSE, the entire plot is included in one single page.}

\item{alpha}{Numeric with transparency, 1 by default.}

\item{shapeSize}{Size for the symbols, any integer or 
object supported by \code{size} in \code{\link[ggplot2]{geom_point}}.}
}
\value{
List of (across subjects) of list (across modules) 
of \code{\link[ggplot2]{ggplot2} objects}, 
also of class \code{subjectProfileLinePlot}.
Each subject profile contains attributes: 'subjectID' and 'nLines' 
(estimated number of lines of space the plot will take).
The entire list also contains attributes: '\code{label}',
'timeLim' and 'timeTrans' (if specified).
}
\description{
Visualize subject profiles of the evolution of 
continuous parameters versus time (spaghetti plot).
}
\seealso{
Other patient profiles plotting function: 
\code{\link{subjectProfileEventPlot}()},
\code{\link{subjectProfileIntervalPlot}()},
\code{\link{subjectProfileTextPlot}()}
}
\author{
Laure Cougnaud
}
\concept{patient profiles plotting function}
