% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{quick_separate_trajectories}
\alias{quick_separate_trajectories}
\title{Quick version of separate_trajectories()}
\usage{
quick_separate_trajectories(obj_name, max_frame_gap = 1, ...)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{max_frame_gap}{Unlike the corresponding parameter in
\code{separate_trajectories}, must be a single numeric here.}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) in which a new column
\code{file_sub_traj} is added, which labels trajectories within the data by
concatenating file name, subject name, and a trajectory number (all
separated by underscores).
}
\description{
Mostly meant for internal use but available nevertheless.
}
\details{
This function is designed to separate rows of data into separately
labeled trajectories.

The \code{max_frame_gap} parameter determines how trajectories will be
separated. \code{max_frame_gap} defines the largest permissible gap in data
before a new trajectory is forced to be defined. In this function, only a
single numeric can be supplied to this parameter (unlike the case in
\code{separate_trajectories}).
}
\examples{
## This function is not recommended for general use.
## See separate_trajectories() instead
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}

Other functions that define or clean trajectories: 
\code{\link{get_full_trajectories}()},
\code{\link{separate_trajectories}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
\concept{functions that define or clean trajectories}
