#' Williams and Anderson (1994) Mediated Multifoci Model Dataset
#'
#' This data set is from Williams and Anderson (1994) on the study of methods effects in organizational research using latent-variable models.
#'
#' @format A variance-covariance \code{matrix} for 232 observations and 12 variables. The variables are indicators of four constructss: 1) job satisfaction (Jobsat; 10 items), 2) organizational committment (Orgcom; 8 items), 3) leader-contingent reward behavior (Ldrrew; 10 items), and 4) job complexity (Jobcom; 6 items). The individual item responses were used to create three, total-score indicators for each construct defined as follows:
#' \describe{
#'  \item{\code{JobsatI1}}{Job satisfaction indicator 1}
#'  \item{\code{JobsatI2}}{Job satisfaction indicator 2}
#'  \item{\code{JobsatI3}}{Job satisfaction indicator 3}
#'  \item{\code{OrgcomI1}}{Organizational committment indicator 1}
#'  \item{\code{OrgcomI2}}{Organizational committment indicator 2}
#'  \item{\code{OrgcomI3}}{Organizational committment indicator 3}
#'  \item{\code{LdrrewI1}}{Leader-contingent reward behavior indicator 1}
#'  \item{\code{LdrrewI2}}{Leader-contingent reward behavior indicator 2}
#'  \item{\code{LdrrewI3}}{Leader-contingent reward behavior indicator 3}
#'  \item{\code{JobcomI1}}{Job complexity indicator 1}
#'  \item{\code{JobcomI2}}{Job complexity indicator 2}
#'  \item{\code{JobcomI3}}{Job complexity indicator 3}
#' }
#' @source Williams, L. J. & Anderson, S. E. (1994). An alternative approach to method effects by using latent-variable models: Applications in organizational behavior research. Journal of Applied Psychology, 79, 323-331.
#'
#' @author Steven Culpepper and Larry Williams
"mediationVC"
