% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{cluster_graph_vis}
\alias{cluster_graph_vis}
\title{Graph Visualization of Clustered Enriched Terms}
\usage{
cluster_graph_vis(
  clu_obj,
  kappa_mat,
  enrichment_res,
  kappa_threshold = 0.35,
  use_description = FALSE,
  vertex.label.cex = 0.7,
  vertex.size.scaling = 2.5
)
}
\arguments{
\item{clu_obj}{clustering result (either a matrix obtained via
\code{\link{hierarchical_term_clustering}} or \code{\link{fuzzy_term_clustering}}
`fuzzy_term_clustering` or a vector obtained via `hierarchical_term_clustering`)}

\item{kappa_mat}{matrix of kappa statistics (output of \code{\link{create_kappa_matrix}})}

\item{enrichment_res}{data frame of pathfindR enrichment results. Must-have
columns are "Term_Description" (if \code{use_description = TRUE}) or "ID"
(if \code{use_description = FALSE}), "Down_regulated", and "Up_regulated".
If \code{use_active_snw_genes = TRUE}, "non_Signif_Snw_Genes" must also be
provided.}

\item{kappa_threshold}{threshold for kappa statistics, defining strong
relation (default = 0.35)}

\item{use_description}{Boolean argument to indicate whether term descriptions
(in the "Term_Description" column) should be used. (default = \code{FALSE})}

\item{vertex.label.cex}{font size for vertex labels; it is interpreted as a multiplication factor of some device-dependent base font size (default = 0.7)}

\item{vertex.size.scaling}{scaling factor for the node size (default = 2.5)}
}
\value{
Plots a graph diagram of clustering results. Each node is an enriched term
from `enrichment_res`. Size of node corresponds to -log(lowest_p). Thickness
of the edges between nodes correspond to the kappa statistic between the two
terms. Color of each node corresponds to distinct clusters. For fuzzy
clustering, if a term is in multiple clusters, multiple colors are utilized.
}
\description{
Graph Visualization of Clustered Enriched Terms
}
\examples{
\dontrun{
cluster_graph_vis(clu_obj, kappa_mat, enrichment_res)
}
}
