% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{enrichment}
\alias{enrichment}
\title{Perform Enrichment Analysis for a Single Gene Set}
\usage{
enrichment(
  input_genes,
  genes_by_term = pathfindR.data::kegg_genes,
  term_descriptions = pathfindR.data::kegg_descriptions,
  adj_method = "bonferroni",
  enrichment_threshold = 0.05,
  sig_genes_vec,
  background_genes
)
}
\arguments{
\item{input_genes}{The set of gene symbols to be used for enrichment
analysis. In the scope of this package, these are genes that were
identified for an active subnetwork}

\item{genes_by_term}{List that contains genes for each gene set. Names of
this list are gene set IDs (default = kegg_genes)}

\item{term_descriptions}{Vector that contains term descriptions for the
gene sets. Names of this vector are gene set IDs (default = kegg_descriptions)}

\item{adj_method}{correction method to be used for adjusting p-values.
(default = "bonferroni")}

\item{enrichment_threshold}{adjusted-p value threshold used when filtering
enrichment results (default = 0.05)}

\item{sig_genes_vec}{vector of significant gene symbols. In the scope of this
package, these are the input genes that were used for active subnetwork search}

\item{background_genes}{vector of background genes. In the scope of this package,
the background genes are taken as all genes in the PIN
(see \code{\link{enrichment_analyses}})}
}
\value{
A data frame that contains enrichment results
}
\description{
Perform Enrichment Analysis for a Single Gene Set
}
\examples{
enrichment(input_genes = c("PER1", "PER2", "CRY1", "CREB1"),
           sig_genes_vec = "PER1",
           background_genes = unlist(pathfindR.data::kegg_genes))
}
\seealso{
\code{\link[stats]{p.adjust}} for adjustment of p values. See
  \code{\link{run_pathfindR}} for the wrapper function of the pathfindR
  workflow. \code{\link{hyperg_test}} for the details on hypergeometric
  distribution-based hypothesis testing.
}
