% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active_snw_functions.R
\name{filterActiveSnws}
\alias{filterActiveSnws}
\title{Parse Active Subnetwork Search Output File and Filter the Subnetworks}
\usage{
filterActiveSnws(active_snw_path, signif_genes, score_quan_thr = 0.8,
  sig_gene_thr = 10)
}
\arguments{
\item{active_snw_path}{path to the output of an Active Subnetwork Search.}

\item{signif_genes}{the vector of significant genes.}

\item{score_quan_thr}{active subnetwork score quantile threshold (Default = 0.80)}

\item{sig_gene_thr}{threshold for minimum number of affected genes (Default = 10)}
}
\value{
A list of genes in every active subnetwork that has a score greater than
the `score_quan_thr`th quantile and that has at least `sig_gene_thr` affected genes.
}
\description{
Parse Active Subnetwork Search Output File and Filter the Subnetworks
}
\examples{
\dontshow{
filterActiveSnws(normalizePath(system.file("extdata/resultActiveSubnetworkSearch.txt",
package = "pathfindR")), pathfindR::RA_input$Gene.symbol)
}
\dontrun{
filterActiveSnws("path/to/output", significant_genes)
}
}
\seealso{
See \code{\link{run_pathfindR}} for the wrapper function of the
  pathfindR workflow
}
