% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwd.R
\name{calculate_pwd}
\alias{calculate_pwd}
\title{Calculate Pairwise Distances Between Given Pathways}
\usage{
calculate_pwd(pathway_ids, pathway_names, agg_method = "average",
  plot_heatmap = FALSE, use_names = FALSE, custom_genes = NULL)
}
\arguments{
\item{pathway_ids}{Vector of IDs of pathways to be used for calculation of pairwise distances.}

\item{pathway_names}{Vector of names of pathways to be used for calculation of pairwise distances.}

\item{agg_method}{the agglomeration method to be used if plotting heatmap
(see next argument, default: average).}

\item{plot_heatmap}{boolean value indicating whether or not to plot the heat
map of pathway clustering (default: FALSE).}

\item{use_names}{boolean value indicating whether to use gene set names instead of gene set ids (default: FALSE)}

\item{custom_genes}{a list containing the genes involved in each custom pathway. Each element
is a vector of gene symbols located in the given pathway. Names correspond to
the ID of the pathway. Must be provided if pathways were obtained using custom
gene sets.}
}
\value{
Pairwise distance matrix. Optionally plots a heatmap of pathway
  clustering.
}
\description{
Calculate Pairwise Distances Between Given Pathways
}
\details{
See "Chen, Y. A. et al. Integrated pathway clusters with coherent
  biological themes for target prioritisation. PLoS One 9, e99030,
  doi:10.1371/journal.pone.0099030 (2014)." for details on the method of
  pathway clustering.
}
\examples{
calculate_pwd(RA_output$ID)
}
\seealso{
\code{\link[stats]{hclust}} for hierarchical clustering,
  \code{\link[stats]{heatmap}} for drawing a heatmap.
}
