% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impose.R, R/wield.R
\name{impose}
\alias{impose}
\alias{reimpose}
\alias{unimpose}
\alias{wield}
\alias{rewield}
\alias{unwield}
\title{Assign a force or constraint to a simulation}
\usage{
impose(simulation, constraint, ..., name, include = TRUE)

reimpose(simulation, name, ...)

unimpose(simulation, name)

wield(simulation, force, ..., name, include = TRUE)

rewield(simulation, name, ...)

unwield(simulation, name)
}
\arguments{
\item{simulation}{A simulation object}

\item{constraint}{A constraint object}

\item{...}{Parameters passed on to the training of the force or constraint}

\item{name}{The name of the force. For use when accessing the force at a
later stage. If no name is given the force is accessible by its index in the
stack.}

\item{include}{The particles to be affected by this force. Defaults to every
particle in the simulation (\emph{tidy eval})}

\item{force}{A force object}
}
\value{
A simulation with the force or constraint added
}
\description{
This function adds a new force/constraint to the simulation and trains the it
on the current particle graph. The parameters passed on to the training are
using tidy evaluation from the rlang package. Depending on the
force/constraint the data getting referenced is either the node or the edge
data of the particle graph. Both forces and constraints manipulate position
and velocity of the particles but they differ in when the are applied during
a generation. First forces are applied sequentially and the resulting
velocity is added to the resulting position after \code{velocity_decay} has been
applied. After this operation any constraint is imposed on the results. In
general, forces tends to calculate velocity adjustments, while constraints
modify position and velocity directly, but this difference is not in any way
enforced.
}
\details{
\code{wield()} and \code{impose()} adds forces and constraints to the simulation
respectively. \code{unwield()} and \code{unimpose()} removes forces and constraints
based on name or index. \code{rewield()} and \code{reimpose()} modifies existing forces
and constraints based on name or index and retrains them.
}
\examples{
graph <- tidygraph::create_notable('folkman')
graph \%>\%
  simulate() \%>\%
  wield(link_force)

}
