% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{simulation_modification}
\alias{simulation_modification}
\alias{add_particles}
\alias{add_interaction}
\title{Modify the particles in a simulation}
\usage{
add_particles(.data, ..., interactions = NULL, setup = NULL)

add_interaction(.data, ...)
}
\arguments{
\item{.data}{A simulation object}

\item{...}{Parameters passed on to the main verbs in tidygraph/dplyr}

\item{interactions}{A data.frame of interactions/edges to add along with the
particles}

\item{setup}{A function to calculate the starting conditions for the
particles. It receives all particles with the current position and
velocity encoded in the \code{x}, \code{y}, \code{x_vel}, and \code{y_vel} columns. New particle
will have NA. The function must return a position and velocity for all
particles even though the values for the current particles will be discarded.
If NULL it will use the genesis function used when creating the simulation.}
}
\value{
A simulation object
}
\description{
The particles that are modelled in a simulation are encoded as a \code{tbl_graph},
giving support for the particles as well as their interactions (nodes and
edges in graph parlor). A simulation supports a subset of the tidygraph/dplyr
verbs in order to allow modification of the particles after they have been
included in the simulation. In general it is possible to add and remove
particles and interactions as well as modify the metadata associated with
them. The API follows the tidygraph API where \code{activate()} is used to select
either particles or interactions and subsequent operations are thus related
to the last activated datatype. The simulation is automatically retrained
after modifying the state of the particles and their interactions.
}
\seealso{
\code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:mutate_at]{dplyr::mutate_at()}}, \code{\link[dplyr:mutate_all]{dplyr::mutate_all()}},
\code{\link[dplyr:filter]{dplyr::filter()}}, \code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[tidygraph:activate]{tidygraph::activate()}},
\code{\link[tidygraph:bind_nodes]{tidygraph::bind_nodes()}}, \code{\link[tidygraph:bind_edges]{tidygraph::bind_edges()}}
}
