% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest_party.R
\name{details_rand_forest_party}
\alias{details_rand_forest_party}
\title{Random forests via party}
\description{
\code{\link[party:cforest]{party::cforest()}} fits a model that creates a large number of decision
trees, each independent of the others. The final prediction uses all
predictions from the individual trees and combines them.
}
\details{
For this engine, there is a single mode: censored regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{trees}: # Trees (type: integer, default: 500L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 20L)
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: 5L)
}
}

\subsection{Translation from parsnip to the original package (censored regression)}{

The \strong{censored} extension package is required to fit this model.\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

rand_forest() \%>\% 
  set_engine("party") \%>\% 
  set_mode("censored regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (censored regression)
## 
## Computational engine: party 
## 
## Model fit template:
## censored::cond_inference_surv_cforest(formula = missing_arg(), 
##     data = missing_arg())
}

\code{censored::cond_inference_surv_cforest()} is a wrapper around
\code{\link[party:cforest]{party::cforest()}} (and other functions) that makes
it easier to run this model.
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Other details}{

The main interface for this model uses the formula method since the
model specification typically involved the use of
\code{\link[survival:Surv]{survival::Surv()}}.
}

\subsection{References}{
\itemize{
\item Hothorn T, Buhlmann P, Dudoit S, Molinaro A, Van der Laan MJ. 2006.
Survival Ensembles. \emph{Biostatistics}, 7(3), 355–373.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
