% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg_glm.R
\name{details_logistic_reg_glm}
\alias{details_logistic_reg_glm}
\title{Logistic regression via glm}
\description{
\code{\link[stats:glm]{stats::glm()}} fits a generalized linear model for binary outcomes. A
linear combination of the predictors is used to model the log odds of an
event.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This engine has no tuning parameters but you can set the \code{family}
parameter (and/or \code{link}) as an engine argument (see below).
}

\subsection{Translation from parsnip to the original package}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{logistic_reg() \%>\% 
  set_engine("glm") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Logistic Regression Model Specification (classification)
## 
## Computational engine: glm 
## 
## Model fit template:
## stats::glm(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     family = stats::binomial)
}

To use a non-default \code{family} and/or \code{link}, pass in as an argument to
\code{set_engine()}:\if{html}{\out{<div class="sourceCode r">}}\preformatted{linear_reg() \%>\% 
  set_engine("glm", family = stats::binomial(link = "probit")) \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Engine-Specific Arguments:
##   family = stats::binomial(link = "probit")
## 
## Computational engine: glm 
## 
## Model fit template:
## stats::glm(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     family = stats::binomial(link = "probit"))
}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip
will convert factor columns to indicators.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#logistic-reg-glm}{examples}
for \code{logistic_reg()} with the \code{"glm"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
