% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_class.R, R/predict_classprob.R,
%   R/predict_hazard.R, R/predict_interval.R, R/predict_linear_pred.R,
%   R/predict_numeric.R, R/predict_quantile.R, R/predict_survival.R,
%   R/predict_time.R
\name{predict_class.model_fit}
\alias{predict_class.model_fit}
\alias{predict_classprob.model_fit}
\alias{predict_hazard.model_fit}
\alias{predict_confint.model_fit}
\alias{predict_linear_pred.model_fit}
\alias{predict_linear_pred}
\alias{predict_numeric.model_fit}
\alias{predict_numeric}
\alias{predict_quantile.model_fit}
\alias{predict_survival.model_fit}
\alias{predict_survival}
\alias{predict_time.model_fit}
\alias{predict_time}
\title{Other predict methods.}
\usage{
\method{predict_class}{model_fit}(object, new_data, ...)

\method{predict_classprob}{model_fit}(object, new_data, ...)

\method{predict_hazard}{model_fit}(object, new_data, time, ...)

\method{predict_confint}{model_fit}(object, new_data, level = 0.95, std_error = FALSE, ...)

\method{predict_linear_pred}{model_fit}(object, new_data, ...)

predict_linear_pred(object, ...)

\method{predict_numeric}{model_fit}(object, new_data, ...)

predict_numeric(object, ...)

\method{predict_quantile}{model_fit}(
  object,
  new_data,
  quantile = (1:9)/10,
  interval = "none",
  level = 0.95,
  ...
)

\method{predict_survival}{model_fit}(object, new_data, time, interval = "none", level = 0.95, ...)

predict_survival(object, ...)

\method{predict_time}{model_fit}(object, new_data, ...)

predict_time(object, ...)
}
\arguments{
\item{object}{An object of class \code{model_fit}}

\item{new_data}{A rectangular data object, such as a data frame.}

\item{...}{Arguments to the underlying model's prediction
function cannot be passed here (see \code{opts}). There are some
\code{parsnip} related options that can be passed, depending on the
value of \code{type}. Possible arguments are:
\itemize{
\item \code{interval}: for \code{type}s of "survival" and "quantile", should
interval estimates be added, if available? Options are \code{"none"}
and \code{"confidence"}.
\item \code{level}: for \code{type}s of "conf_int", "pred_int", and "survival"
this is the parameter for the tail area of the intervals
(e.g. confidence level for confidence intervals).
Default value is 0.95.
\item \code{std_error}: add the standard error of fit or prediction (on
the scale of the linear predictors) for \code{type}s of "conf_int"
and "pred_int". Default value is \code{FALSE}.
\item \code{quantile}: the quantile(s) for quantile regression
(not implemented yet)
\item \code{time}: the time(s) for hazard and survival probability estimates.
}}

\item{level}{A single numeric value between zero and one for the
interval estimates.}

\item{std_error}{A single logical for whether the standard error should be
returned (assuming that the model can compute it).}

\item{quantile}{A vector of numbers between 0 and 1 for the quantile being
predicted.}
}
\description{
These are internal functions not meant to be directly called by the user.
}
\keyword{internal}
