% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_summary.R
\name{surv_summary}
\alias{surv_summary}
\title{Summary statistics based on parametric distribution}
\usage{
surv_summary(data, dist, time = "time", censor = "censor", by = "")
}
\arguments{
\item{data}{A dataframe containing a time column and a censor column.}

\item{dist}{A string name for a distribution that has a corresponding density function and a distribution function.
Examples include "norm", "lnorm", "exp", "weibull", "logis", "llogis", "gompertz", etc.}

\item{time}{The string name of the time column of the dataframe. Defaults to "time".}

\item{censor}{The string name of the censor column of the dataframe. Defaults to "censor". 
The censor column must be a numeric indicator variable where complete times correspond 
to a value of 1 and incomplete times correspond to 0.}

\item{by}{The string name of a grouping variable. If specified, returns summary statistics for each group.
Variable can contain logical, string, character, or numeric data.}
}
\description{
Estimates various statistics, including median, mean, standard deviation, and 
percentiles of survival time given that the data follows a specified parametric distribution.
}
\examples{
data("rearrest")
surv_summary(rearrest, "lnorm", time = "months")
surv_summary(rearrest, "weibull", time = "months", by = "personal")
}
