% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_distribution.R
\name{describe_distribution}
\alias{describe_distribution}
\title{Describe a Distribution}
\usage{
describe_distribution(
  x,
  centrality = "mean",
  dispersion = TRUE,
  range = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{dispersion}{Logical, if \code{TRUE}, computes indices of dispersion related to the estimate(s) (\code{SD} and \code{MAD} for \code{mean} and \code{median}, respectively).}

\item{range}{Return the range (min and max).}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
Converted index.
}
\description{
This function describes a distribution by a set of indices (e.g., measures of centrality, dispersion, range, skewness, kurtosis).
}
\examples{
describe_distribution(rnorm(100))
}
