% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_standard_error.R, R/methods_DirichletReg.R,
%   R/methods_averaging.R, R/methods_base.R, R/methods_betareg.R,
%   R/methods_glmmTMB.R, R/methods_lme4.R, R/methods_mfx.R, R/methods_mixmod.R,
%   R/methods_mixor.R, R/methods_ordinal.R, R/methods_pscl.R,
%   R/methods_survival.R
\name{standard_error}
\alias{standard_error}
\alias{standard_error.default}
\alias{standard_error.DirichletRegModel}
\alias{standard_error.averaging}
\alias{standard_error.factor}
\alias{standard_error.betareg}
\alias{standard_error.glmmTMB}
\alias{standard_error.merMod}
\alias{standard_error.poissonmfx}
\alias{standard_error.betamfx}
\alias{standard_error.MixMod}
\alias{standard_error.mixor}
\alias{standard_error.clm2}
\alias{standard_error.zeroinfl}
\alias{standard_error.coxph}
\title{Standard Errors}
\usage{
standard_error(model, ...)

\method{standard_error}{default}(
  model,
  component = "all",
  vcov = NULL,
  vcov_args = NULL,
  verbose = TRUE,
  ...
)

\method{standard_error}{DirichletRegModel}(model, component = c("all", "conditional", "precision"), ...)

\method{standard_error}{averaging}(model, component = c("conditional", "full"), ...)

\method{standard_error}{factor}(model, force = FALSE, verbose = TRUE, ...)

\method{standard_error}{betareg}(model, component = c("all", "conditional", "precision"), ...)

\method{standard_error}{glmmTMB}(
  model,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  verbose = TRUE,
  ...
)

\method{standard_error}{merMod}(
  model,
  effects = c("fixed", "random"),
  method = NULL,
  vcov = NULL,
  vcov_args = NULL,
  ...
)

\method{standard_error}{poissonmfx}(model, component = c("all", "conditional", "marginal"), ...)

\method{standard_error}{betamfx}(
  model,
  component = c("all", "conditional", "precision", "marginal"),
  ...
)

\method{standard_error}{MixMod}(
  model,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated"),
  verbose = TRUE,
  ...
)

\method{standard_error}{mixor}(model, effects = "all", ...)

\method{standard_error}{clm2}(model, component = c("all", "conditional", "scale"), ...)

\method{standard_error}{zeroinfl}(
  model,
  component = c("all", "conditional", "zi", "zero_inflated"),
  method = NULL,
  verbose = TRUE,
  ...
)

\method{standard_error}{coxph}(model, method = NULL, ...)
}
\arguments{
\item{model}{A model.}

\item{...}{Arguments passed to or from other methods.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"}, \code{"dispersion"} or \code{"all"}
(default). May be abbreviated.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance matrix,
a function which returns a covariance matrix, or a string which identifies
the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"vcovHC"}, \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}.
\item Cluster-robust: \code{"vcovCR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"}, \code{"CR2"}, \code{"CR3"}. See \code{?clubSandwich::vcovCR}.
\item Bootstrap: \code{"vcovBS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"}, \code{"webb"}. See \code{?sandwich::vcovBS}.
\item Other \code{sandwich} package functions: \code{"vcovHAC"}, \code{"vcovPC"}, \code{"vcovCL"}, \code{"vcovPL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the \emph{sandwich}
or \emph{clubSandwich} packages. Please refer to their documentation (e.g.,
\code{?sandwich::vcovHAC}) to see the list of available arguments.}

\item{verbose}{Toggle warnings and messages.}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values to calculate the standard error, with the lowest level being the
value \code{1} (unless the factor has numeric levels, which are converted
to the corresponding numeric value). By default, \code{NA} is returned for
factors or character vectors.}

\item{effects}{Should standard errors for fixed effects or random effects be
returned? Only applies to mixed models. May be abbreviated. When standard
errors for random effects are requested, for each grouping factor a list of
standard errors (per group level) for random intercepts and slopes is
returned.}

\item{method}{For linear mixed models, \code{method} can be
\code{\link[=p_value_kenward]{"kenward"}} or
\code{\link[=p_value_satterthwaite]{"satterthwaite"}}.}
}
\value{
A data frame with at least two columns: the parameter names and the
standard errors. Depending on the model, may also include columns for model
components etc.
}
\description{
\code{standard_error()} attempts to return standard errors of model
parameters
}
\note{
For Bayesian models (from \pkg{rstanarm} or \pkg{brms}), the standard
error is the SD of the posterior samples.
}
\examples{
model <- lm(Petal.Length ~ Sepal.Length * Species, data = iris)

standard_error(model)

standard_error(model, vcov = "HC3")

standard_error(model,
               vcov = "vcovCL",
               vcov_args = list(cluster = iris$Species))
}
