% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_st.R
\name{param_st}
\alias{param_st}
\alias{param_t}
\title{Solve Skew-\eqn{t} Parameters from Moments}
\usage{
param_st(mean = 0, sd = 1, skewness, kurtosis)

param_t(sd = 1, kurtosis)
}
\arguments{
\item{mean}{\link[base]{numeric} scalar, mean, default value 0}

\item{sd}{\link[base]{numeric} scalar, standard deviation, default value 1}

\item{skewness}{\link[base]{numeric} scalar}

\item{kurtosis}{\link[base]{numeric} scalar}
}
\value{
Function \link{param_st} returns a \link[base]{length}-4 \link[base]{numeric} \link[base]{vector}
\eqn{(\xi, \omega, \alpha, \nu)}.

Function \link{param_t} returns a \link[base]{length}-2
\link[base]{numeric} \link[base]{vector} \eqn{(\omega, \nu)}.
}
\description{
Solve skew-\eqn{t} parameters from mean, standard deviation, skewness and kurtosis.
}
\details{
Function \link{param_st} solves the
location \eqn{\xi}, scale \eqn{\omega}, slant \eqn{\alpha}
and degree of freedom \eqn{\nu} parameters of skew-\eqn{t} distribution,
from user-specified mean \eqn{\mu}, standard deviation \eqn{\sigma},
skewness and kurtosis.

A education and demonstration function \link{param_t} solves the
scale \eqn{\omega} and degree of freedom \eqn{\nu} parameters of \eqn{t}-distribution,
from user-specified standard deviation \eqn{\sigma} and kurtosis.
This is a non-skewed distribution, thus
the location parameter \eqn{\xi} is the mean \eqn{\mu}, and the slant parameter \eqn{\alpha=0}.
}
\examples{
param_st(skewness = .2, kurtosis = .3)

param_t(kurtosis = .3)

}
