% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_sn.R
\name{param_sn}
\alias{param_sn}
\title{Solve Skew-Normal Parameters from Moments}
\usage{
param_sn(mean = 0, sd = 1, skewness)
}
\arguments{
\item{mean}{\link[base]{numeric} scalar, mean, default value 0}

\item{sd}{\link[base]{numeric} scalar, standard deviation, default value 1}

\item{skewness}{\link[base]{numeric} scalar}
}
\value{
Function \link{param_sn} returns a \link[base]{numeric} \link[base]{vector} of
\link[base]{length}-3, representing the
location \eqn{\xi}, scale \eqn{\omega} and slant \eqn{\alpha} parameters.
}
\description{
Solve skew-normal parameters from mean, standard deviation and skewness.
}
\examples{
param_sn(skewness = .3)

}
