#' Register available parallelization levels in a client package.
#'
#' Call this in your\code{\link{.onLoad}} in your \dQuote{zzz.R}.
#'
#' @param package [\code{character(1)}]\cr
#'   Name of your package.
#' @param levels [\code{character(1)}]\cr
#'   Availabe levels that are used in the \code{\link{parallelMap}} operations of your package.
#' @return Nothing.
#' @export
parallelRegisterLevels = function(package, levels) {
  assertString(package)
  assertCharacter(levels, any.missing = FALSE)
  reg.levs = getPMOption("registered.levels", list())
  reg.levs[[package]] = levels
  options(parallelMap.registered.levels = reg.levs)
  invisible(NULL)
}

#' Display registered parallelization levels for all currently loaded packages.
#'
#' @return Invisibly returns a list object that contains the displayed information.
#' @export
parallelShowRegisteredLevels = function() {
  reg.levs = getPMOption("registered.levels")
  for (i in seq_along(reg.levs)) {
    p = names(reg.levs)[[i]]
    levs = reg.levs[[i]]
    catf("%-20s: %s", p, collapse(levs))
  }
  invisible(reg.levs)
}  
