% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Service.R
\name{Service}
\alias{Service}
\title{Service}
\description{
This is an interface that defines the operations available on a
\code{\link{Backend}} implementation. Backend implementations and the
\code{\link{Context}} class must implement this interface.
}
\seealso{
\code{\link{Backend}}, \code{\link{SyncBackend}}, \code{\link{AsyncBackend}},
and \code{\link{Context}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Service-new}{\code{Service$new()}}
\item \href{#method-Service-start}{\code{Service$start()}}
\item \href{#method-Service-stop}{\code{Service$stop()}}
\item \href{#method-Service-clear}{\code{Service$clear()}}
\item \href{#method-Service-peek}{\code{Service$peek()}}
\item \href{#method-Service-export}{\code{Service$export()}}
\item \href{#method-Service-evaluate}{\code{Service$evaluate()}}
\item \href{#method-Service-sapply}{\code{Service$sapply()}}
\item \href{#method-Service-lapply}{\code{Service$lapply()}}
\item \href{#method-Service-apply}{\code{Service$apply()}}
\item \href{#method-Service-get_output}{\code{Service$get_output()}}
\item \href{#method-Service-clone}{\code{Service$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-new"></a>}}
\if{latex}{\out{\hypertarget{method-Service-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{Service}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Instantiating this call will throw an error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-start"></a>}}
\if{latex}{\out{\hypertarget{method-Service-start}{}}}
\subsection{Method \code{start()}}{
Start the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$start(specification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{specification}}{An object of class \code{\link{Specification}}
that contains the backend configuration.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The resulting backend must be stored in the
\code{.cluster} private field on the \code{\link{Backend}} abstract class,
and accessible to any concrete backend implementations via the active
binding \code{cluster}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Service-stop}{}}}
\subsection{Method \code{stop()}}{
Stop the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$stop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-clear"></a>}}
\if{latex}{\out{\hypertarget{method-Service-clear}{}}}
\subsection{Method \code{clear()}}{
Remove all objects from the backend. This function is equivalent to
calling \code{rm(list = ls(all.names = TRUE))} on each node in the
backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$clear()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This method is ran by default when the backend is started.
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-peek"></a>}}
\if{latex}{\out{\hypertarget{method-Service-peek}{}}}
\subsection{Method \code{peek()}}{
Inspect the backend for variables available in the \code{.GlobalEnv}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$peek()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns a list of character vectors, where each element
corresponds to a node in the backend. The character vectors contain
the names of the variables available in the \code{.GlobalEnv} on each
node.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-export"></a>}}
\if{latex}{\out{\hypertarget{method-Service-export}{}}}
\subsection{Method \code{export()}}{
Export variables from a given environment to the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$export(variables, environment)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variables}}{A character vector of variable names to export.}

\item{\code{environment}}{An environment object from which to export the
variables.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-Service-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
Evaluate an arbitrary expression on the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$evaluate(expression)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expression}}{An unquoted expression to evaluate on the backend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns the result of the expression evaluation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-sapply"></a>}}
\if{latex}{\out{\hypertarget{method-Service-sapply}{}}}
\subsection{Method \code{sapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parSapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$sapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-lapply"></a>}}
\if{latex}{\out{\hypertarget{method-Service-lapply}{}}}
\subsection{Method \code{lapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parLapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$lapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-apply"></a>}}
\if{latex}{\out{\hypertarget{method-Service-apply}{}}}
\subsection{Method \code{apply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parApply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$apply(x, margin, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An array to pass to the \code{fun} function.}

\item{\code{margin}}{A numeric vector indicating the dimensions of \code{x} the
\code{fun} function should be applied over. For example, for a matrix,
\code{margin = 1} indicates applying \code{fun} rows-wise, \code{margin = 2}
indicates applying \code{fun} columns-wise, and \code{margin = c(1, 2)}
indicates applying \code{fun} element-wise. Named dimensions are also
possible depending on \code{x}. See \code{\link[parallel:clusterApply]{parallel::parApply()}} and
\code{\link[base:apply]{base::apply()}} for more details.}

\item{\code{fun}}{A function to apply to \code{x} according to the \code{margin}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-get_output"></a>}}
\if{latex}{\out{\hypertarget{method-Service-get_output}{}}}
\subsection{Method \code{get_output()}}{
Get the output of the task execution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$get_output(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional optional arguments that may be used by concrete
implementations.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method fetches the output of the task execution after calling
the \code{sapply()} method. It returns the output and immediately removes
it from the backend. Therefore, subsequent calls to this method are
not advised. This method should be called after the execution of a
task.
}

\subsection{Returns}{
A vector, matrix, or list of the same length as \code{x}, containing the
results of the \code{fun}. The output format differs based on the specific
operation employed. Check out the documentation for the \code{apply}
operations of \code{\link[parallel:parallel-package]{parallel::parallel}} for more information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Service-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Service-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Service$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
