% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsyncBackend.R
\name{AsyncBackend}
\alias{AsyncBackend}
\title{AsyncBackend}
\description{
This is a concrete implementation of the abstract class \code{\link{Backend}}
that implements the \code{\link{Service}} interface. This backend executes
tasks in parallel asynchronously (i.e., without blocking the main \code{R}
session) on a \code{\link[parallel:makeCluster]{parallel::makeCluster()}} cluster created in a background \code{R}
\code{\link[callr:r_session]{session}}.
}
\examples{
# Create a specification object.
specification <- Specification$new()

# Set the number of cores.
specification$set_cores(cores = 2)

# Set the cluster type.
specification$set_type(type = "psock")

# Create an asynchronous backend object.
backend <- AsyncBackend$new()

# Start the cluster on the backend.
backend$start(specification)

# Check if there is anything on the backend.
backend$peek()

# Create a dummy variable.
name <- "parabar"

# Export the variable to the backend.
backend$export("name")

# Remove variable from current environment.
rm(name)

# Run an expression on the backend, using the exported variable `name`.
backend$evaluate({
    # Print the name.
    print(paste0("Hello, ", name, "!"))
})

# Run a task in parallel (i.e., approx. 2.5 seconds).
backend$sapply(
    x = 1:10,
    fun = function(x) {
        # Sleep a bit.
        Sys.sleep(0.5)

        # Compute something.
        output <- x + 1

        # Return the result.
        return(output)
    }
)

# Right know the main process is free and the task is executing on a `psock`
# cluster started in a background `R` session.

# Trying to get the output immediately will throw an error, indicating that the
# task is still running.
try(backend$get_output())

# However, we can block the main process and wait for the task to complete
# before fetching the results.
backend$get_output(wait = TRUE)

# Clear the backend.
backend$clear()

# Check that there is nothing on the cluster.
backend$peek()

# Stop the backend.
backend$stop()

# Check that the backend is not active.
backend$active

}
\seealso{
\code{\link{Service}}, \code{\link{Backend}}, \code{\link{SyncBackend}},
\code{\link{ProgressTrackingContext}}, and \code{\link{TaskState}}.
}
\section{Super classes}{
\code{\link[parabar:Service]{parabar::Service}} -> \code{\link[parabar:Backend]{parabar::Backend}} -> \code{AsyncBackend}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{task_state}}{A list of logical values indicating the state of
the task execution. See the \code{\link{TaskState}} class for more
information on how the statues are determined. The following statuses
are available:
\itemize{
\item \code{task_not_started}: Indicates whether the backend is free. \code{TRUE}
signifies that no task has been started and the backend is free to
deploy.
\item \code{task_is_running}: Indicates whether a task is currently running on
the backend.
\item \code{task_is_completed}: Indicates whether a task has finished
executing. \code{TRUE} signifies that the output of the task has not been
fetched. Calling the method \code{get_option()} will move the output from
the background \code{R} session to the main \code{R} session. Once the output
has been fetched, the backend is free to deploy another task.
}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AsyncBackend-new}{\code{AsyncBackend$new()}}
\item \href{#method-AsyncBackend-finalize}{\code{AsyncBackend$finalize()}}
\item \href{#method-AsyncBackend-start}{\code{AsyncBackend$start()}}
\item \href{#method-AsyncBackend-stop}{\code{AsyncBackend$stop()}}
\item \href{#method-AsyncBackend-clear}{\code{AsyncBackend$clear()}}
\item \href{#method-AsyncBackend-peek}{\code{AsyncBackend$peek()}}
\item \href{#method-AsyncBackend-export}{\code{AsyncBackend$export()}}
\item \href{#method-AsyncBackend-evaluate}{\code{AsyncBackend$evaluate()}}
\item \href{#method-AsyncBackend-sapply}{\code{AsyncBackend$sapply()}}
\item \href{#method-AsyncBackend-lapply}{\code{AsyncBackend$lapply()}}
\item \href{#method-AsyncBackend-apply}{\code{AsyncBackend$apply()}}
\item \href{#method-AsyncBackend-get_output}{\code{AsyncBackend$get_output()}}
\item \href{#method-AsyncBackend-clone}{\code{AsyncBackend$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-new"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{AsyncBackend}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{\link{AsyncBackend}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-finalize}{}}}
\subsection{Method \code{finalize()}}{
Destroy the current \code{\link{AsyncBackend}} instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$finalize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{\link{AsyncBackend}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-start"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-start}{}}}
\subsection{Method \code{start()}}{
Start the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$start(specification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{specification}}{An object of class \code{\link{Specification}}
that contains the backend configuration.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The resulting backend must be stored in the
\code{.cluster} private field on the \code{\link{Backend}} abstract class,
and accessible to any concrete backend implementations via the active
binding \code{cluster}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-stop"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-stop}{}}}
\subsection{Method \code{stop()}}{
Stop the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$stop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-clear"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-clear}{}}}
\subsection{Method \code{clear()}}{
Remove all objects from the backend. This function is equivalent to
calling \code{rm(list = ls(all.names = TRUE))} on each node in the
backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-peek"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-peek}{}}}
\subsection{Method \code{peek()}}{
Inspect the backend for variables available in the \code{.GlobalEnv}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$peek()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns a list of character vectors, where each element
corresponds to a node in the backend. The character vectors contain
the names of the variables available in the \code{.GlobalEnv} on each
node.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-export"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-export}{}}}
\subsection{Method \code{export()}}{
Export variables from a given environment to the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$export(variables, environment)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variables}}{A character vector of variable names to export.}

\item{\code{environment}}{An environment object from which to export the
variables.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
Evaluate an arbitrary expression on the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$evaluate(expression)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expression}}{An unquoted expression to evaluate on the backend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns the result of the expression evaluation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-sapply"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-sapply}{}}}
\subsection{Method \code{sapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parSapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$sapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-lapply"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-lapply}{}}}
\subsection{Method \code{lapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parLapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$lapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-apply"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-apply}{}}}
\subsection{Method \code{apply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parApply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$apply(x, margin, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An array to pass to the \code{fun} function.}

\item{\code{margin}}{A numeric vector indicating the dimensions of \code{x} the
\code{fun} function should be applied over. For example, for a matrix,
\code{margin = 1} indicates applying \code{fun} rows-wise, \code{margin = 2}
indicates applying \code{fun} columns-wise, and \code{margin = c(1, 2)}
indicates applying \code{fun} element-wise. Named dimensions are also
possible depending on \code{x}. See \code{\link[parallel:clusterApply]{parallel::parApply()}} and
\code{\link[base:apply]{base::apply()}} for more details.}

\item{\code{fun}}{A function to apply to \code{x} according to the \code{margin}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-get_output"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-get_output}{}}}
\subsection{Method \code{get_output()}}{
Get the output of the task execution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$get_output(wait = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{wait}}{A logical value indicating whether to wait for the task
to finish executing before fetching the results. Defaults to \code{FALSE}.
See the \strong{Details} section for more information.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method fetches the output of the task execution after calling
the \code{sapply()} method. It returns the output and immediately removes
it from the backend. Subsequent calls to this method will throw an
error if no additional tasks have been executed in the meantime. This
method should be called after the execution of a task.

If \code{wait = TRUE}, the method will block the main process until the
backend finishes executing the task and the results are available. If
\code{wait = FALSE}, the method will immediately attempt to fetch the
results from the background \code{R} session, and throw an error if the
task is still running.
}

\subsection{Returns}{
A vector, matrix, or list of the same length as \code{x}, containing the
results of the \code{fun}. The output format differs based on the specific
operation employed. Check out the documentation for the \code{apply}
operations of \code{\link[parallel:parallel-package]{parallel::parallel}} for more information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncBackend-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncBackend-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncBackend$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
