% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.r
\name{get_option}
\alias{get_option}
\alias{set_option}
\alias{set_default_options}
\title{Get or Set Package Option}
\usage{
get_option(option)

set_option(option, value)

set_default_options()
}
\arguments{
\item{option}{A character string representing the name of the option to
retrieve or adjust. See the public fields of \code{\link[R6:R6Class]{R6::R6}} class
\code{\link{Options}} for the list of available \code{\link{parabar}}
\code{\link[base:options]{options}}.}

\item{value}{The value to set the \code{\link[=Options]{option}} to.}
}
\value{
The \code{\link[=get_option]{get_option()}} function returns the value of the requested
\code{\link[=Options]{option}} present in the \code{\link[base:options]{base::.Options}} list, or its
corresponding default value (i.e., see \code{\link{Options}}). If the
requested \code{\link[=Options]{option}} is not known, an error is thrown.

The \code{\link[=set_option]{set_option()}} function returns void. It throws an error if the
requested \code{\link[=Options]{option}} to be adjusted is not known.

The \code{\link[=set_default_options]{set_default_options()}} function returns void. The
\code{\link[base:options]{options}} set can be consulted via the \code{\link[base:options]{base::.Options}}
list. See the \code{\link{Options}} \code{\link[R6:R6Class]{R6::R6}} class for more information on
the default values set by this function.
}
\description{
The \code{\link[=get_option]{get_option()}} function is a helper for retrieving the value of
\code{\link{parabar}} \code{\link[base:options]{options}}. If the
\code{\link[=Options]{option}} requested is not available in the session
\code{\link[base:options]{base::.Options}} list, the corresponding default value set by the
\code{\link{Options}} \code{\link[R6:R6Class]{R6::R6}} class is returned instead.

The \code{\link[=set_option]{set_option()}} function is a helper for setting
\code{\link{parabar}} \code{\link[base:options]{options}}. The function adjusts the
fields of the \code{\link{Options}} instance stored in the \code{\link[base:options]{base::.Options}}
list. If no \code{\link{Options}} instance is present in the
\code{\link[base:options]{base::.Options}} list, a new one is created.

The \code{\link[=set_default_options]{set_default_options()}} function is used to set the default
\code{\link[base:options]{options}} values for the \code{\link{parabar}} package. The
function is automatically called at package load and the entry created can be
retrieved via \code{\link[base:options]{getOption("parabar")}}. Specific package
\code{\link[base:options]{options}} can be retrieved using the helper function
\code{\link[=get_option]{get_option()}}.
}
\examples{
# Get the status of progress tracking.
get_option("progress_track")

# Set the status of progress tracking to `FALSE`.
set_option("progress_track", FALSE)

# Get the status of progress tracking again.
get_option("progress_track")

# Restore default options.
set_default_options()

# Get the status of progress tracking yet again.
get_option("progress_track")

}
\seealso{
\code{\link{Options}}, \code{\link[=set_default_options]{set_default_options()}}, \code{\link[base:options]{base::options()}},
and \code{\link[base:options]{base::getOption()}}.
}
