% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelMeasles.R
\name{panelMeasles}
\alias{panelMeasles}
\title{Make a panelPomp model using UK measles data.}
\usage{
panelMeasles(
  units = c("Bedwellty", "Birmingham", "Bradford", "Bristol", "Cardiff", "Consett",
    "Dalton.in.Furness", "Halesworth", "Hastings", "Hull", "Leeds", "Lees", "Liverpool",
    "London", "Manchester", "Mold", "Northwich", "Nottingham", "Oswestry", "Sheffield"),
  starting_pparams = NULL,
  interp_method = c("shifted_splines", "linear"),
  first_year = 1950,
  last_year = 1963,
  dt = 1/365.25
)
}
\arguments{
\item{units}{Character vector of units in \link{uk_measles} to be used in the
panel model.}

\item{starting_pparams}{Parameters in the list format, having shared and
specific components. Set to NULL to assign NA values.}

\item{interp_method}{Method used to interpolate population and births.
Possible options are \code{"shifted_splines"} and \code{"linear"}.}

\item{first_year}{Integer for the first full year of data desired.}

\item{last_year}{Integer for the last full year of data desired.}

\item{dt}{Size of the time step.}
}
\value{
A panelPomp object.
}
\description{
The model is a modified \link{panelPomp} version of the model of
He et al. 2010. The model is a stochastic SEIR model that accounts for
population demographics in the form of births and deaths. Because of the
increased transmission that results from school-aged children entering the
susceptible pool once they begin attending classes for the first time, the
model includes a birth-cohort effect, which moves a specified faction of
the cohort into the susceptible pool all at once. The model also includes
a seasonality in transmission rate that is larger during school terms thn
it is during holidays.
}
\examples{
panelMeasles(units = "London")

}
\references{
\He2010
}
\seealso{
Other panelPomp examples: 
\code{\link{contacts}()},
\code{\link{panelGompertz}()},
\code{\link{panelRandomWalk}()}
}
\concept{panelPomp examples}
