% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{unitLogLik}
\alias{unitLogLik}
\title{Extract log likelihood of units of panel models}
\usage{
unitLogLik(object, ...)
}
\arguments{
\item{object}{an object for which log likelihood values for units can be extracted.}

\item{...}{additional arguments.}
}
\value{
Log likelihood extracted for each unit of the panel model \code{object}.

\unitLogLikReturn
}
\description{
\code{unitLogLik()} is a generic function that extracts the log
likelihood for each unit of panel objects returned by panel modeling functions.
While the \code{numeric} value with the log likelihood for the entire panel
is useful and possible via S4 methods \code{logLik()}, the contributions to it
by panel units can be implemented via \code{unitLogLik()}.
}
\details{
This is a generic function: methods can be defined for it.
}
\examples{
# filter, which generates log likelihoods
pfrw <- pfilter(panelRandomWalk(),Np=10)
# extract log likelihood for each panel unit
unitLogLik(pfrw)
}
\seealso{
\link{pfilter}
}
\author{
Carles \Breto
}
\keyword{internal}
