% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs-math.R
\name{colour-mixing-math}
\alias{colour-mixing-math}
\alias{color-mixing-math}
\alias{sum.palettes_colour}
\alias{cumsum.palettes_colour}
\title{Mix colour vectors with math functions}
\usage{
\method{sum}{palettes_colour}(..., na.rm = FALSE)

\method{cumsum}{palettes_colour}(x)
}
\arguments{
\item{...}{Colour vectors of class \code{palettes_colour}.}

\item{na.rm}{Whether to include missing values. Either \code{TRUE} or \code{FALSE}.}

\item{x}{An object of class \code{palettes_colour}.}
}
\value{
These functions return colour vectors of class \code{palettes_colour}:
\itemize{
\item \code{sum()} returns the sum of all the colours present in its arguments with
additive colour mixing.
\item \code{cumsum()} returns a vector whose elements are the cumulative sums of the
elements of the argument with additive colour mixing.
}
}
\description{
These functions mix colour vectors with math functions.
}
\examples{
x <- pal_colour(c("red", "blue"))
sum(x)

x <- pal_colour(c("red", "blue", "yellow"))
cumsum(x)
}
