% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaleoPopModel.R
\name{PaleoPopModel}
\alias{PaleoPopModel}
\title{R6 class representing a population model for the paleopop simulator}
\description{
\code{\link[R6:R6Class]{R6}} class representing a
spatially-explicit demographic-based population model. It extends the
\code{\link{SimulationModel}} class with parameters for the
\code{\link{paleopop_simulator}}. It inherits functionality for creating a
nested model, whereby a nested template model with fixed parameters is
maintained when a model is cloned for various sampled parameters. Also
provided are extensions to the methods for checking the consistency and
completeness of model parameters.
}
\examples{
library(poems)
library(raster)
# Ring Island example region
coordinates <- data.frame(x = rep(seq(-178.02, -178.06, -0.01), 5),
                          y = rep(seq(19.02, 19.06, 0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
sealevel_raster <- template_raster
template_raster[][c(7:9, 12:14, 17:19)] <- NA # make Ring Island
sealevel_raster[][c(7:9, 12:14, 17:18)] <- NA
raster_stack <- raster::stack(x = append(replicate(9, template_raster), sealevel_raster))
region <- PaleoRegion$new(template_raster = raster_stack)

# Model template
template_model <- PaleoPopModel$new(simulation_function = "paleopop_simulator", # the default
                                    region = region, years_per_step = 25, # default: 1 year
                                    time_steps = 10)
template_model$required_attributes # more requirements than the SimulationModel object in poems
template_model$is_complete() # the required attributes have not been filled in
template_model#is_consistent() # however, the attributes that are filled in are consistent

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{\link[poems:SimulationModel]{poems::SimulationModel}} -> \code{PaleoPopModel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{simulation_function}}{Name (character string) or source path of the default simulation function, which takes a model as an input and returns the simulation results.}

\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population coordinates (WGS84) in longitude (degrees West) and latitude (degrees North).}

\item{\code{random_seed}}{Number to seed the random number generation for stochasticity.}

\item{\code{time_steps}}{Number of simulation time steps.}

\item{\code{years_per_step}}{Number of years per time step.}

\item{\code{populations}}{Number of population cells.}

\item{\code{initial_abundance}}{Array (matrix) of initial abundance values at each population cell.}

\item{\code{transition_rate}}{Rate (numeric) of transition between generations at each time-step.}

\item{\code{standard_deviation}}{Standard deviation (numeric) for applying environmental stochasticity to transition rates.}

\item{\code{compact_decomposition}}{List containing a compact transposed (Cholesky) decomposition \emph{matrix} (t_decomposition_compact_matrix) and a corresponding \emph{map} of population indices (t_decomposition_compact_map), as per \code{\link{SpatialCorrelation}} class attributes.}

\item{\code{carrying_capacity}}{Array (or matrix) of carrying capacity values at each population cell (across time).}

\item{\code{density_dependence}}{Density dependence type ("competition", "logistic", or "ceiling").}

\item{\code{growth_rate_max}}{Maximum growth rate (utilized by density dependence processes).}

\item{\code{dispersal_data}}{List of data frames of non-zero dispersal rates and indices for constructing a compact dispersal matrix, and optional changing rates over time, as per class \code{\link{DispersalGenerator}} \emph{dispersal_data} attribute.}

\item{\code{dispersal_target_k}}{Target population carrying capacity threshold for density dependent dispersal.}

\item{\code{harvest}}{Boolean for utilizing harvesting.}

\item{\code{harvest_max}}{Proportion harvested per year (annual time scale - not generational).}

\item{\code{harvest_g}}{The "G" parameter in the harvest function.}

\item{\code{harvest_z}}{The "Z" parameter in the harvest function.}

\item{\code{harvest_max_n}}{Maximum density per grid cell.}

\item{\code{human_density}}{Matrix of human density (fraction) ($populations rows by $time_steps columns).}

\item{\code{abundance_threshold}}{Abundance threshold (that needs to be exceeded) for each population to persist.}

\item{\code{occupancy_threshold}}{Threshold for the number of populations occupied (that needs to be exceeded) for all populations to persist.}

\item{\code{results_selection}}{List of results selection from ("abundance", "ema", "extirpation", "harvested", "occupancy", "human_density").}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{template_model}}{Nested template model for fixed (non-sampled) attributes for shallow cloning.}

\item{\code{sample_attributes}}{Vector of sample attribute names (only).}

\item{\code{required_attributes}}{Vector of required attribute names (only), i.e. those needed to run a simulation.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PaleoPopModel-list_consistency}{\code{PaleoPopModel$list_consistency()}}
\item \href{#method-PaleoPopModel-list_completeness}{\code{PaleoPopModel$list_completeness()}}
\item \href{#method-PaleoPopModel-clone}{\code{PaleoPopModel$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="get_attribute_names"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-get_attribute_names'><code>poems::SimulationModel$get_attribute_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="get_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-get_attributes'><code>poems::SimulationModel$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="incomplete_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-incomplete_attributes'><code>poems::SimulationModel$incomplete_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="inconsistent_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-inconsistent_attributes'><code>poems::SimulationModel$inconsistent_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="initialize"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-initialize'><code>poems::SimulationModel$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="is_complete"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-is_complete'><code>poems::SimulationModel$is_complete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="is_consistent"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-is_consistent'><code>poems::SimulationModel$is_consistent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="new_clone"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-new_clone'><code>poems::SimulationModel$new_clone()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="set_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-set_attributes'><code>poems::SimulationModel$set_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="SimulationModel" data-id="set_sample_attributes"><a href='../../poems/html/SimulationModel.html#method-SimulationModel-set_sample_attributes'><code>poems::SimulationModel$set_sample_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaleoPopModel-list_consistency"></a>}}
\if{latex}{\out{\hypertarget{method-PaleoPopModel-list_consistency}{}}}
\subsection{Method \code{list_consistency()}}{
Returns a boolean to indicate if (optionally selected or all) model attributes (such as dimensions) are consistent.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoPopModel$list_consistency(params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Optional array of parameter/attribute names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of booleans (or NAs) to indicate consistency of selected/all attributes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaleoPopModel-list_completeness"></a>}}
\if{latex}{\out{\hypertarget{method-PaleoPopModel-list_completeness}{}}}
\subsection{Method \code{list_completeness()}}{
Returns a list of booleans (or NAs) for each parameter to indicate attributes that are necessary to simulate the model have been set and are consistent/valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoPopModel$list_completeness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of booleans (or NAs) for each parameter to indicate to indicate completeness (and consistency).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaleoPopModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PaleoPopModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoPopModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
