% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{fit9models}
\alias{fit9models}
\title{Fit large set of models to a time-series}
\usage{
fit9models(y, silent = FALSE, method = c("Joint", "AD"), ...)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{silent}{logical, if TRUE, progress updates are suppressed}

\item{method}{parameterization to use: \code{Joint} or \code{AD}; see Details}

\item{...}{other arguments, passed to optimization functions}
}
\value{
if silent = FALSE, a table of model fit statistics, also printed to the
screen.  if silent = TRUE, a list of the model fit statistics and model parameter values.
}
\description{
This function fits nine models to a time-series following Hunt et al. (2015). These
include the simple models fit by \code{fit4models} along with mode shift and
punctuation models.
}
\examples{
\dontrun{
x <- sim.Stasis.RW(ns = c(15, 15), omega = 0.5, ms = 1, order = "Stasis-RW")
plot(x)
fit9models(x)
}
}
\references{
Hunt, G., M. J. Hopkins and S. Lidgard. 2015. Simple versus complex models of trait evolution
and stasis as a response to environmental change. PNAS 112(16): 4885-4890.
}
