% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{redraw.phylo}
\alias{redraw.phylo}
\title{Redraw the lines of a phylogenetic tree.}
\usage{
redraw.phylo(
  saved_plot = NULL,
  col = "black",
  lwd = 1,
  lty = 1,
  lend = 2,
  arrow.l = 0,
  arrow.angle = 45,
  arrow.code = 2,
  indices = NULL
)
}
\arguments{
\item{saved_plot}{Optional saved plot (e.g. using get("last_plot.phylo", envir = ape::.PlotPhyloEnv)) to be used instead of currently active plot.}

\item{col}{Color to be used for redrawing tree edges.}

\item{lwd}{Line width to be used for redrawing tree edges.}

\item{lty}{Line type to be used for redrawing tree edges.}

\item{lend}{Style of line ends to be used for redrawing tree edges.}

\item{arrow.l}{Length of arrow ends to be used for plotting. Defaults to 0, i.e. no visible arrow.}

\item{arrow.angle}{Angle of arrow ends to be used for plotting. Defaults to 45 degrees.}

\item{arrow.code}{Arrow code to be used for plotting. For details, see ?arrows}

\item{indices}{Optional indices which edges to redraw. Can be used to highlight specific edges in different color or style.}
}
\value{
Plots a timescale on the currently active plot.
}
\description{
Redraw the lines of a phylogenetic tree.
}
\examples{
data(tree_archosauria)
ape::plot.phylo(tree_archosauria)
redraw.phylo(col="darkred",lwd=3,indices=c(19:24))
redraw.phylo(col="red",lwd=3,indices=c(18),arrow.l=0.1)
}
