% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_install_dev_deps}
\alias{local_install_dev_deps}
\title{Install all dependencies of a package tree}
\usage{
local_install_dev_deps(root = ".", lib = .libPaths()[1],
  upgrade = FALSE, ask = interactive())
}
\arguments{
\item{root}{Path to the package tree.}

\item{lib}{Package library to install the packages to. Note that \emph{all}
dependent packages will the be installed here, even if they are
already installed in another library.}

\item{upgrade}{Whether to upgrade already installed packages to the
latest available version. If this is \code{FALSE}, then only packages
that need updates to satisfy version requirements, will be updated.
If it is \code{TRUE}, all specified or dependent packages will be updated
to the latest available version.}

\item{ask}{Whether to ask for confirmation.}
}
\description{
Installs all dependencies of a package tree (or source package file),
without installing the package tree itself. It installs the development
dependencies as well, specified in the \code{Suggests} field of
\code{DESCRIPTION}.
}
\seealso{
Other local package trees: \code{\link{local_install_deps}},
  \code{\link{local_install}},
  \code{\link{local_package_trees}}
}
\concept{local package trees}
