% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_expr_helpers.R
\name{pairwise_caption}
\alias{pairwise_caption}
\title{Expression containing details about pairwise comparison test}
\usage{
pairwise_caption(caption, test.description, p.adjust.method)
}
\arguments{
\item{caption}{Additional text to be included in the plot.}

\item{test.description}{Text describing the details of the test.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}
}
\description{
This returns an expression containing details about the pairwise
comparison test and the \emph{p}-value adjustment method. These details are
typically included in \code{ggstatsplot} package plots as a caption.
}
\examples{
library(pairwiseComparisons)
pairwise_caption("my caption", "Student's t-test", "holm")
}
