% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pact.R
\name{print.eval.cv}
\alias{print.eval.cv}
\title{Print an object of class 'eval.cv'}
\usage{
\method{print}{eval.cv}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{The object returned from \code{'eval.pact.cv'}}

\item{digits}{significant digits in the print}

\item{...}{Additional print arguments}
}
\value{
The statistics comparing treatments E and C is printed. The printed statistics differs
according to whether \code{method} was \code{'discrete'} or \code{'continuous'}. p-values are 
printed if \code{perm.test=TRUE}
}
\description{
print method for objects of class 'eval.cv'
}
\details{
The call that produced the object is printed, followed by the evaluation statistics. 
 The p-values are printed if permutation testing was asked for.
}
\examples{
data(prostateCancer)
Y <- prostateCancer[,3:4]
Xf <- prostateCancer[,7:8]
Xv <- prostateCancer[,c(5:6,9)]
Treatment <- as.factor(prostateCancer[,2])
p <- pact.fit(Y=Y, Xf=Xf, Xv=Xv, Treatment=Treatment, family="cox", varSelect="lasso")
cv <- pact.cv(p, nfold=5)
eval <- eval.pact.cv(cv, method="discrete", g=log(0.80))
eval
}
\author{
Jyothi Subramanian and Richard Simon
\cr Maintainer: Jyothi Subramanian <\email{subramanianj01@gmail.com}>
}

