% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dependencies.R
\name{appDependencies}
\alias{appDependencies}
\title{Detect Application Dependencies}
\usage{
appDependencies(project = NULL, available.packages = NULL,
  fields = c("Imports", "Depends", "LinkingTo"))
}
\arguments{
\item{project}{Directory containing application. Defaults to current working
directory.}
}
\value{
Returns a list of the names of the packages on which R code in the
  application depends.
}
\description{
Recursively detect all package dependencies for an application. This function
parses all \R files in the application directory to determine what packages
the application depends directly.
}
\details{
Only direct dependencies are detected (i.e. no recursion is done to find the
dependencies of the dependencies).

Dependencies are determined by parsing application source code and
  looking for calls to \code{library}, \code{require}, \code{::}, and
  \code{:::}.
}
\examples{
\dontrun{

# dependencies for the app in the current working dir
appDependencies()

# dependencies for an app in another directory
appDependencies("~/projects/shiny/app1")

}
}
\keyword{internal}

