% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_parameter_estimation_survival.R
\name{predict_coxph}
\alias{predict_coxph}
\title{Predict risk/hazard function for  cox ph regression}
\usage{
predict_coxph(
  coxfit,
  dataset,
  param_to_be_estimated,
  covariates,
  indep_var,
  timevar_survival
)
}
\arguments{
\item{coxfit}{cox regression fit result}

\item{dataset}{param describing the methods}

\item{param_to_be_estimated}{parameter to be estimated}

\item{covariates}{covariates}

\item{indep_var}{independent variable}

\item{timevar_survival}{time variable}
}
\value{
plot and the survival function values
}
\description{
Predict risk/hazard function for  cox ph regression
}
\details{
"risk" option for "type" returns the hazard ratio relative to mean
e.g given below For lung data with
data_for_survival <- survival::lung
fit <- use_coxph_survival("status", data_for_survival, "sex",
covariates = c("ph.ecog"), "time")
coeffit = fit$coefficients
r1234 <- exp(coeffit("sex")lung$sex+ coeffit("ph.ecog")lung$ph.ecog)
rMean <- exp(sum(coef(fit) * fit$means, na.rm=TRUE))
rr <- r1234/rMean
}
\examples{
\donttest{
data_for_survival <- survival::lung
surv_estimated <- use_coxph_survival("status", data_for_survival,
"sex",covariates = c("ph.ecog"), "time")
predict_coxph(surv_estimated$fit,data_for_survival, "status","sex",
covariates = c("ph.ecog"), "time")
}
}
