% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{combine_markov}
\alias{combine_markov}
\title{Join Markov model objects}
\usage{
combine_markov(markov1, ...)
}
\arguments{
\item{markov1}{object 1 of class markov_model}

\item{...}{any additional objects}
}
\value{
joined objects of type markov_model
}
\description{
Join Markov model objects
}
\details{
Combining Markov models for easiness of comparison
}
\examples{
well <- health_state("well", cost = 0, utility = 1)
disabled <- health_state("disabled", cost = 100, utility = 1)
dead <- health_state("dead", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3), c(NA, 4, 5), c(NA, NA, 6))
colnames(tmat) <- rownames(tmat) <- c("well", "disabled", "dead")
tm <- populate_transition_matrix(3, tmat, c(0.6, 0.2, 0.2, 0.6, 0.4, 1))
health_states <- combine_state(well, disabled, dead)
this.strategy <- strategy(tm, health_states, "example")
this_markov <- markov_model(this.strategy, 24, c(1000, 0, 0))
well <- health_state("well", cost = 0, utility = 1)
disabled <- health_state("disabled", cost = 10, utility = 0.5)
dead <- health_state("dead", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3), c(NA, 4, 5), c(NA, NA, 6))
colnames(tmat) <- rownames(tmat) <- c("well", "disabled", "dead")
tm <- populate_transition_matrix(3, tmat, c(0.4, 0.4, 0.2, 0.6, 0.4, 1))
health_states <- combine_state(well, disabled, dead)
this.strategy <- strategy(tm, health_states, "example")
sec_markov <- markov_model(this.strategy, 24, c(1000, 0, 0))
list_markov <- combine_markov(this_markov, sec_markov)
}
