% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{eval_assign_values_states}
\alias{eval_assign_values_states}
\title{Attribute values in health states}
\usage{
eval_assign_values_states(health_states, assigned_param)
}
\arguments{
\item{health_states}{list of health_state objects}

\item{assigned_param}{name value pairs of parameter values in the
probability matrix
expected created using function assign_parameters()}
}
\value{
health states with assigned values
}
\description{
Attribute values in health states
}
\details{
Assigning the param is done for the cost and utility
if the param is not numeric, check if it can be evaluated at the run time
if yes, assign the evaluated numeric value
if not get the parameters between operators, and assign the values to
each individual parameters and then evaluate. only works for two levels.
For the example shown the cost is sum of cost_A and cost_B which will
only get added in the call eval_assign_values_states
While initialising the state "well" it will be only saved as
expression(cost_A + cost_B)
assigned_param (a list) can be expected to be created using
assign_parameters() the exception is if parameter is directly assigned
with no nested calculation and no missing parameters.
For example assigned_param = c(cost_a = 10, cost_b=10) will be ok
but not assigned_param = c(a=10, cost_A = "a+100", cost_B =10) as it requires
a nested calculation then use define_parameters() with assign_parameters()
as in param_list <- define_parameters(a = 10, cost_A = "a + 100",
cost_B = 10)
assign_list <- assign_parameters(param_list)
}
\examples{
\donttest{
well <- health_state("well", cost = "cost_A + cost_B", utility = 1)
disabled <- health_state("disabled", cost = 100, utility = 1)
dead <- health_state("dead", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3), c(NA, 4, 5), c(NA, NA, 6))
colnames(tmat) <- rownames(tmat) <- c("well", "disabled", "dead")
tm <- populate_transition_matrix(3, tmat, c(0.6, 0.2, 0.2, 0.6, 0.4, 1))
health_states <- combine_state(well, disabled, dead)
eval_assign_values_states(health_states, c(cost_A = 100, cost_B = 11))
}
}
