% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ozmap.R
\name{ozmap}
\alias{ozmap}
\title{Australia map}
\usage{
ozmap(x = "states", ..., add = FALSE)
}
\arguments{
\item{x}{name of data set to use, default is \code{ozmap_country}}

\item{...}{arguments passed to ...}

\item{add}{add to existing plot, \code{FALSE} by default}
}
\value{
the data set used, in 'sf' format
}
\description{
Draw a map of Australia, with or without states.
}
\details{
outline data is purely in longitude-latitude form, see
\code{ozmap_data()} to obtain the data itself.`

See \code{abs_ste} for more detailed versions from the Australian Bureau of Statistics.
An example is 'abs_ste' which means 'State and Territory', and
so is a more detailed version of 'states'.

\code{ozmap()} uses the sf package to plot, but does so by only plotting the
geometry rather than every colum, and leaves the plot region ready for overplotting with other
data.
}
\examples{
ozmap()
ozmap("country", lwd = 6)
ozmap("abs_ced", add = TRUE, border = "firebrick")  ## commonwealth (national) electoral divisions
}
\seealso{
ozmap_data
}
