% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get policy actions and stringency data from JSON}
\usage{
get_data(json)
}
\arguments{
\item{json}{A JSON string, URL or file created using \code{\link[=get_json_time]{get_json_time()}} or
\code{\link[=get_json_actions]{get_json_actions()}}.}
}
\value{
A tibble of time series stringency index data if \code{json} is a time
\strong{series endpoint} or a named list of two tibbles (the first tibble is
named \code{policyActions} and the second tibble is named \code{stringencyData}) if
\code{json} is a \strong{policy actions endpoint}.
}
\description{
Get policy actions and stringency data from JSON
}
\examples{
## Get time series JSON endpoint
x <- get_json_time(from = "2020-10-29", to = "2020-10-31")

## Get time series stringency index data
get_data(x)

## Get policy actions JSON endpoint
x <- get_json_actions(ccode = "AFG", from = NULL, to = "2020-07-16")

## Get data on policy actions and stringency index
get_data(x)

}
