% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_print.R
\name{overview_print}
\alias{overview_print}
\title{overview_print}
\usage{
overview_print(
  obj,
  title = "Time and scope of the sample",
  id = "Sample",
  time = "Time frame",
  crosstab = FALSE,
  cond1 = "Condition 1",
  cond2 = "Condition 2",
  save_out = FALSE,
  path,
  file,
  label = "tab:tab1",
  fontsize
)
}
\arguments{
\item{obj}{Overview object produced by overview_tab or overview_crosstab}

\item{title}{Caption of the table (default is "Time and scope of the sample")}

\item{id}{The name of the left column (default is "Sample"), will be ignored
if crosstab is TRUE}

\item{time}{The name of the right column (default is ("Time frame")), will
be ignored if \code{crosstab} is TRUE}

\item{crosstab}{Logical argument, if TRUE produces a \code{crosstab} output,
default is FALSE}

\item{cond1}{Description for the first condition (character), will be
ignored if \code{crosstab} is FALSE. This should correspond to the input
for \code{cond1} in \code{overview_crosstab}}

\item{cond2}{Description for the second condition (character), will be
ignored if \code{crosstab} is FALSE. This should correspond to the input
for \code{cond2} in \code{overview_crosstab}}

\item{save_out}{Optional argument, exports the output table as a .tex
file, default is FALSE}

\item{path}{Specifies the path where the output should be saved}

\item{file}{Specifies name and file type (.tex)}

\item{label}{Specifies the label (default is "tab:tab1")}

\item{fontsize}{Specifies the font size (all 'LaTeX' font sizes such as
"scriptsize" or "small" work)}
}
\value{
A 'LaTeX' output that can either be copy-pasted in a text document or
    exported directed as a .tex file
}
\description{
Produces a 'LaTeX' output for output obtained via
   \code{overview_tab} and \code{overview_crosstab}
}
\examples{
data(toydata)

overview_object <- overview_tab(dat = toydata, id = ccode, time = year)
overview_print(
  obj = overview_object,
  title = "Some nice title",
  crosstab = FALSE
)

overview_ct_object <- overview_crosstab(
  dat = toydata,
  cond1 = gdp,
  cond2 = population,
  threshold1 = 25000,
  threshold2 = 27000,
  id = ccode,
  time = year
)
overview_print(
  obj = overview_ct_object,
  title = "Some nice title for a cross tab",
  crosstab = TRUE,
  cond1 = "Name of first condition",
  cond2 = "Name of second condition"
)
}
