% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stage_conn.R
\name{stage_conn}
\alias{stage_conn}
\alias{strike_stage}
\title{create a cachable duckdb connection. In dev}
\usage{
stage_conn(
  dbdir = ":memory:",
  read_only = FALSE,
  bigint = "numeric",
  config = list(),
  ...
)

strike_stage(conn = stage_conn())
}
\arguments{
\item{dbdir}{Location for database files. Should be a path to an existing
directory in the file system. With the default (or \code{""}), all
data is kept in RAM.}

\item{read_only}{Set to \code{TRUE} for read-only operation.
For file-based databases, this is only applied when the database file is opened for the first time.
Subsequent connections (via the same \code{drv} object or a \code{drv} object pointing to the same path)
will silently ignore this flag.}

\item{bigint}{How 64-bit integers should be returned. There are two options: \code{"numeric"} and \code{"integer64"}.
If \code{"numeric"} is selected, bigint integers will be treated as double/numeric.
If \code{"integer64"} is selected, bigint integers will be set to bit64 encoding.}

\item{config}{Named list with DuckDB configuration flags, see
\url{https://duckdb.org/docs/configuration/overview#configuration-reference} for the possible options.
These flags are only applied when the database object is instantiated.
Subsequent connections will silently ignore these flags.}

\item{...}{Further arguments passed to \link[DBI:dbConnect]{DBI::dbConnect}}

\item{conn}{A \code{duckdb_connection} object}
}
\value{
a \code{\link[duckdb:duckdb]{duckdb::duckdb()}}connection object
}
\description{
\code{stage_conn} is primarily intended for internal use by other
\code{overtureR} functions.  However, it can be called directly by
the user whenever it is desirable to have direct access to the
connection object. The core code is copied from \code{duckdbfs}, which deserves
all credit for the implementation
}
\details{
When first called (by a user or internal function),
this function both creates a duckdb connection and places
that connection into a cache (\code{overturer_conn} option).
On subsequent calls, this function returns the cached connection,
rather than recreating a fresh connection.

This frees the user from the responsibility of managing a
connection object, because functions needing access to the
connection can use this to create or access the existing connection.
At the close of the global environment, this function's finalizer
should gracefully shutdown the connection before removing the cache.

\code{strike_stage} closes the connection.
}
\examples{

con <- stage_conn()
strike_stage(con)

}
