% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect.overture_call}
\alias{collect.overture_call}
\alias{collect_sf}
\title{Convert dbplyr table to sf Object}
\usage{
\method{collect}{overture_call}(x, ..., geom_col = "geometry", crs = 4326)

collect_sf(...)
}
\arguments{
\item{x}{A lazy data frame backed by a database query.}

\item{...}{Further arguments passed to \code{\link[dplyr:compute]{dplyr::collect()}}.}

\item{geom_col}{The name of the geometry column. Will auto-detect names
matching 'geom'.}

\item{crs}{The coordinate reference system to use for the geometries, specified
by its EPSG code. The default is 4326 (WGS 84).}
}
\value{
An 'sf' object with the dataset converted to spatial features.
}
\description{
Collects a lazy dbplyr view and materializes it as an
in-memory \code{sf} table. \code{collect_sf} is a deprecated alias.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

bbox <- c(xmin = -120.5, ymin = 35.5, xmax = -120.0, ymax = 36.0)
lazy_tbl <- open_curtain("building", bbox)
collect(lazy_tbl)
\dontshow{\}) # examplesIf}
}
