% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_sf.R
\name{collect_sf}
\alias{collect_sf}
\title{Convert dbplyr table to sf Object}
\usage{
collect_sf(tbl, geom_col = NULL, crs = 4326)
}
\arguments{
\item{tbl}{A dbplyr view object containing a 'geometry' column.}

\item{geom_col}{The name of the geometry column. Will auto-detect names
matching 'geom'.}

\item{crs}{The coordinate reference system to use for the geometries, specified
by its EPSG code. The default is 4326 (WGS 84).}
}
\value{
An 'sf' object with the dataset converted to spatial features.
}
\description{
Collects a lazy dbplyr view and materializes it as an
in-memory \code{sf} table.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

bbox <- c(xmin = -120.5, ymin = 35.5, xmax = -120.0, ymax = 36.0)
lazy_tbl <- open_curtain("building", bbox)
collect_sf(lazy_tbl)
\dontshow{\}) # examplesIf}
}
