% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brown.R
\name{brown}
\alias{brown}
\title{Phylogenetic Brownian motion models}
\usage{
brown(data, tree)
}
\arguments{
\item{data}{Phenotypic data for extant species, i.e., at the terminal ends
of the phylogenetic tree.  This can either be a numeric vector or a list.
If it is a numeric vector, there must be one entry for every node.  If it is
a list, it must consist entirely of numeric vectors, each of which has one
entry per node.  A data-frame is coerced to a list.}

\item{tree}{A phylogenetic tree, specified as an \code{ouchtree} object.}
}
\value{
\code{brown} returns an object of class \code{browntree}.
}
\description{
The function \code{brown} creates a \code{browntree} object by fitting a
Brownian-motion model to data.
}
\references{
\Butler2004
}
\seealso{
\code{\link{ouchtree}}, \code{\link{hansen}}, \code{\link{bimac}}, \code{\link{anolis.ssd}}
}
\author{
Aaron A. King
}
\keyword{models}
