% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz.R
\name{parse_quiz}
\alias{parse_quiz}
\alias{extract_quiz}
\title{Parse Quiz and Other Checking Functions}
\usage{
parse_quiz(quiz_lines, quiz_name = NULL, verbose = FALSE)

extract_quiz(quiz_lines)
}
\arguments{
\item{quiz_lines}{A quiz's contents read in with readLines()}

\item{quiz_name}{A character vector indicating the name of the quiz.}

\item{verbose}{Would you like progress messages? TRUE/FALSE}
}
\value{
A list of elements, including a `data.frame` and metadata
for questions

the lines of the quiz that actually contain of the content of the quiz.
}
\description{
Parse Quiz and Other Checking Functions

Extract lines of the quiz
}
\examples{

quiz_lines <- c(
  "{quiz, id: quiz_00_filename}",
  "### Lesson Name quiz",
  "{choose-answers: 4}",
  "? What do you think?",
  "",
  "C) The answer to this one",
  "o) Not the answer",
  "o) Not the answer either",
  "C) Another correct answer",
  "m) Mandatory different answer",
  "",
  "{/quiz}"
)
quiz_specs <- parse_quiz(quiz_lines)
check_quiz_attributes(quiz_specs)
}
