% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz.R
\name{check_all_questions}
\alias{check_all_questions}
\title{Check all quiz questions}
\usage{
check_all_questions(quiz_specs, quiz_name = NA, verbose = TRUE)
}
\arguments{
\item{quiz_specs}{quiz_specs which is output from [ottrpal::parse_quiz].}

\item{quiz_name}{The name of the quiz being checked.}

\item{verbose}{Whether progress messages should be given.}
}
\value{
A list of the output from [ottrpal::check_question] with messages/warnings regarding each question and each check.
}
\description{
Takes output from [ottrpal::parse_quiz] and runs checks on each question in a quiz by calling [ottrpal::check_question] for each question.
First splits questions into their own data frame. Returns a list of messages/warnings about each question's set up.
}
\examples{
\dontrun{

# Using good quiz md example

quiz_path <- good_quiz_path()
good_quiz <- readLines(quiz_path)
good_quiz_specs <- parse_quiz(good_quiz)
good_quiz_checks <- check_all_questions(good_quiz_specs)

# Using bad quiz md example

bad_quiz <- readLines(bad_quiz_path())
bad_quiz_specs <- parse_quiz(bad_quiz)
bad_quiz_checks <- check_all_questions(bad_quiz_specs)
}
}
