% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDetectorScore_GetLabels.R
\name{GetLabels}
\alias{GetLabels}
\title{Get Lables}
\usage{
GetLabels(data)
}
\arguments{
\item{data}{All dataset with training and test datasets with at least \code{timestamp},
\code{value}, \code{is.anomaly}, \code{is.real.anomaly}, \code{start.limit} and
\code{end.limit} columns.}
}
\value{
Same data set with two additional columns \code{label} and \code{first.tp}.
\code{first.tp} indicates for each window Which is the position of first true positive.
\code{label} indicates for each detection if it is a TP, FP, TN or FN.
}
\description{
\code{GetLabels} Calculates the start and end positions of each window that
are focused on the real anomalies. This windows can be used to know if the detected anomaly is a
true positive or not.
}
\details{
\code{data} must be a data.frame with  \code{timestamp}, \code{value}, \code{is.anomaly}
and \code{is.real.anomaly} columns. \code{timestamp} column can be numeric, of type POSIXct, or a
character type date convertible to POSIXct. see  \code{\link{GetWindowsLimits}} to know more
about how to get \code{start.limit} and \code{end.limit} columns.
}
\examples{
## Generate data
set.seed(100)
n <- 180
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

# Add is.real.anomaly column
df$is.real.anomaly <- 0
df[c(25,80,150), "is.real.anomaly"] <- 1

## Calculate anomalies
result <- CpSdEwma(
  data = df$value,
  n.train = 5,
  threshold = 0.01,
  l = 3
)
res <- cbind(df, result)

# Get Window Limits
data <- GetWindowsLimits(res)
data[data$is.real.anomaly == 1,]

# Get labels
data <- GetLabels(data)
data[data$is.real.anomaly == 1 | data$is.anomaly == 1,]

# Plot results
PlotDetections(res, print.real.anomaly = TRUE, print.time.window = TRUE)
}
\references{
A. Lavin and S. Ahmad, “Evaluating Real-time Anomaly Detection Algorithms – the
Numenta Anomaly Benchmark,” in 14th International Conference on Machine Learning and
Applications (IEEE ICMLA’15), 2015.
}
